/*
 * Decompiled with CFR 0.152.
 */
package jung.myalghoritm.myDepthSearch;

import edu.uci.ics.jung.graph.Graph;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import jung.myalghoritm.MyShortestPath;
import org.apache.commons.collections15.Transformer;
import org.apache.log4j.Logger;
import sk.stuba.fiit.pogamut.jungigation.objects.MyEdge;
import sk.stuba.fiit.pogamut.jungigation.objects.MyVertice;

public class DepthFirstSearchPathPlanner
implements MyShortestPath<MyVertice, MyEdge> {
    private static final Logger log = Logger.getLogger(DepthFirstSearchPathPlanner.class);
    protected final Transformer<MyEdge, ? extends Number> transformer;
    private final Graph<MyVertice, MyEdge> graph;
    private int vertexCount = -4;
    MyVertice[] vertices = null;
    MyVertice source = null;
    MyVertice target = null;

    public DepthFirstSearchPathPlanner(Graph<MyVertice, MyEdge> graph, Transformer<MyEdge, ? extends Number> transformer) {
        this.graph = graph;
        this.transformer = transformer;
    }

    @Override
    public List<MyEdge> getPath(MyVertice source, MyVertice target) {
        log.debug("Going to compute path from " + source + " to " + target + ".");
        return this.runDFSmain(source, target);
    }

    public List<MyEdge> runDFSmain(MyVertice source, MyVertice target) {
        this.source = source;
        this.target = target;
        this.vertexCount = this.graph.getVertexCount();
        Collection vert = this.graph.getVertices();
        this.vertices = vert.toArray(new MyVertice[this.vertexCount]);
        int sourceVertexIndex = -1;
        for (int i = 0; i < this.vertexCount; ++i) {
            if (!source.equals(this.vertices[i])) continue;
            sourceVertexIndex = i;
        }
        MyVertice pom = this.vertices[0];
        this.vertices[0] = this.vertices[sourceVertexIndex];
        this.vertices[sourceVertexIndex] = pom;
        List<MyEdge> vratene = this.runDFS(0, new Stack<Integer>());
        if (vratene == null || vratene.size() == 0) {
            throw new RuntimeException("Path not reachable! Path from " + source + ", to " + target);
        }
        return vratene;
    }

    private List<MyEdge> runDFS(int u, Stack<Integer> currentPath) {
        if (currentPath.contains(u)) {
            return null;
        }
        currentPath.push(u);
        MyVertice uv = this.vertices[u];
        LinkedList<MyEdge> navrat = new LinkedList<MyEdge>();
        for (int v = 0; v < this.vertexCount; ++v) {
            if (u == v) continue;
            MyVertice vv = this.vertices[v];
            log.trace("Going to examine edge from " + uv.getId() + " to " + vv.getId() + ".");
            if (!this.graph.isSuccessor(uv, vv)) continue;
            if (vv.equals(this.target)) {
                log.debug("Found first path to target.");
                LinkedList<MyEdge> path = new LinkedList<MyEdge>();
                path.add((MyEdge)this.graph.findEdge(uv, vv));
                return path;
            }
            List<MyEdge> vratene = this.runDFS(v, currentPath);
            if (vratene == null) continue;
            vratene.add(0, (MyEdge)this.graph.findEdge(uv, vv));
            return vratene;
        }
        currentPath.pop();
        return navrat;
    }
}

