/*
 * Decompiled with CFR 0.152.
 */
package jung.myio;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.io.GraphIOException;
import edu.uci.ics.jung.io.graphml.EdgeMetadata;
import edu.uci.ics.jung.io.graphml.GraphMetadata;
import edu.uci.ics.jung.io.graphml.HyperEdgeMetadata;
import edu.uci.ics.jung.io.graphml.NodeMetadata;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import jung.myio.GraphWriter;
import org.apache.commons.collections15.Transformer;

public class GraphMLWriter2<G extends Hypergraph<V, E>, V, E>
implements GraphWriter<G, V, E> {
    private final Writer fileWriter;
    private final Transformer<G, GraphMetadata> graphTransformer;
    private final Transformer<V, NodeMetadata> vertexTransformer;
    private final Transformer<E, EdgeMetadata> edgeTransformer;
    private final Transformer<E, HyperEdgeMetadata> hyperEdgeTransformer;
    private boolean directed = false;

    public GraphMLWriter2(Writer fileWriter, Transformer<G, GraphMetadata> graphTransformer, Transformer<V, NodeMetadata> vertexTransformer, Transformer<E, EdgeMetadata> edgeTransformer, Transformer<E, HyperEdgeMetadata> hyperEdgeTransformer) {
        if (fileWriter == null) {
            throw new IllegalArgumentException("Argument fileWriter must be non-null");
        }
        if (graphTransformer == null) {
            throw new IllegalArgumentException("Argument graphTransformer must be non-null");
        }
        if (vertexTransformer == null) {
            throw new IllegalArgumentException("Argument vertexTransformer must be non-null");
        }
        if (edgeTransformer == null) {
            throw new IllegalArgumentException("Argument edgeTransformer must be non-null");
        }
        this.fileWriter = fileWriter;
        this.graphTransformer = graphTransformer;
        this.vertexTransformer = vertexTransformer;
        this.edgeTransformer = edgeTransformer;
        this.hyperEdgeTransformer = hyperEdgeTransformer;
    }

    public Transformer<G, GraphMetadata> getGraphTransformer() {
        return this.graphTransformer;
    }

    public Transformer<V, NodeMetadata> getVertexTransformer() {
        return this.vertexTransformer;
    }

    public Transformer<E, EdgeMetadata> getEdgeTransformer() {
        return this.edgeTransformer;
    }

    public Transformer<E, HyperEdgeMetadata> getHyperEdgeTransformer() {
        return this.hyperEdgeTransformer;
    }

    @Override
    public void close() throws GraphIOException {
        try {
            if (this.fileWriter != null) {
                this.fileWriter.close();
            }
        }
        catch (IOException ex) {
            throw new GraphIOException("Error while closing filewriter in close method! Error:" + ex.getMessage(), ex);
        }
    }

    @Override
    public void writeGraph(G graph) throws GraphIOException {
        try {
            Writer wr = this.fileWriter;
            wr.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            wr.write("<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns/graphml\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"  \n");
            wr.write("xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns/graphml\">\n");
            this.fileWriter.write("<graph edgedefault=\"");
            boolean bl = this.directed = !(graph instanceof UndirectedGraph);
            if (this.directed) {
                wr.write("directed\">\n");
            } else {
                wr.write("undirected\">\n");
            }
            GraphMetadata gm = this.getGraphTransformer().transform(graph);
            String desc = gm.getDescription();
            if (desc != null) {
                wr.write("<desc>" + desc + "</desc>\n");
            }
            for (Map.Entry<String, String> keyValue : gm.getProperties().entrySet()) {
                if (keyValue.getValue() == null) continue;
                wr.write(this.format("data", "key", keyValue.getKey(), keyValue.getValue()) + "\n");
            }
            this.writeVertexData((Hypergraph<V, E>)graph, wr);
            this.writeEdgeData((Hypergraph<V, E>)graph, wr);
            wr.write("</graph>\n");
            wr.write("</graphml>\n");
            wr.flush();
            this.close();
        }
        catch (Exception ex) {
            throw new GraphIOException("Unable to read Graph from document - the document could be empty");
        }
    }

    protected void writeVertexData(Hypergraph<V, E> graph, Writer w) throws IOException {
        for (V v : graph.getVertices()) {
            NodeMetadata nm = this.vertexTransformer.transform(v);
            String v_string = String.format("<node id=\"%s\"", nm.getId());
            boolean closed = false;
            String desc = nm.getDescription();
            if (desc != null) {
                w.write(v_string + ">\n");
                closed = true;
                w.write("<desc>" + desc + "</desc>\n");
            }
            for (Map.Entry<String, String> keyValue : nm.getProperties().entrySet()) {
                if (keyValue.getValue() == null) continue;
                if (!closed) {
                    w.write(v_string + ">\n");
                    closed = true;
                }
                w.write(this.format("data", "key", keyValue.getKey(), keyValue.getValue()) + "\n");
            }
            if (!closed) {
                w.write(v_string + "/>\n");
                continue;
            }
            w.write("</node>\n");
        }
    }

    protected void writeEdgeData(Hypergraph<V, E> g, Writer w) throws IOException {
        for (E e : g.getEdges()) {
            String e_string;
            boolean is_hyperedge;
            EdgeMetadata em = this.edgeTransformer.transform(e);
            Collection<V> vertices = g.getIncidentVertices(e);
            String id = em.getId();
            boolean bl = is_hyperedge = !(g instanceof Graph);
            if (is_hyperedge) {
                e_string = "<hyperedge ";
                if (id != null) {
                    e_string = e_string + "id=\"" + id + "\" ";
                }
            } else {
                Pair<V> endpoints = new Pair<V>(vertices);
                V v1 = endpoints.getFirst();
                V v2 = endpoints.getSecond();
                e_string = "<edge ";
                if (id != null) {
                    e_string = e_string + "id=\"" + id + "\" ";
                }
                EdgeType edge_type = g.getEdgeType(e);
                if (this.directed && edge_type == EdgeType.UNDIRECTED) {
                    e_string = e_string + "directed=\"false\" ";
                }
                if (!this.directed && edge_type == EdgeType.DIRECTED) {
                    e_string = e_string + "directed=\"true\" ";
                }
                e_string = e_string + "source=\"" + this.vertexTransformer.transform(v1).getId() + "\" target=\"" + this.vertexTransformer.transform(v2).getId() + "\"";
            }
            boolean closed = false;
            String desc = em.getDescription();
            if (desc != null) {
                w.write(e_string + ">\n");
                closed = true;
                w.write("<desc>" + desc + "</desc>\n");
            }
            Iterator<Map.Entry<String, String>> i$ = em.getProperties().entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry<String, String> keyValue = i$.next();
                if (keyValue.getValue() == null) continue;
                if (!closed) {
                    w.write(e_string + ">\n");
                    closed = true;
                }
                w.write(this.format("data", "key", keyValue.getKey(), keyValue.getValue()) + "\n");
            }
            if (is_hyperedge && (i$ = vertices.iterator()).hasNext()) {
                Map.Entry<String, String> v = i$.next();
                if (!closed) {
                    w.write(e_string + ">\n");
                    closed = true;
                }
                throw new RuntimeException("Hyperedge saving is not implemented. Please consult source code :-/");
            }
            if (!closed) {
                w.write(e_string + "/>\n");
                continue;
            }
            if (is_hyperedge) {
                w.write("</hyperedge>\n");
                continue;
            }
            w.write("</edge>\n");
        }
    }

    protected String format(String type, String attr, String value, String contents) {
        return String.format("<%s %s=\"%s\">%s</%s>", type, attr, value, contents, type);
    }
}

