/*
 * Decompiled with CFR 0.152.
 */
package math.geom3d;

import javax.vecmath.Tuple3d;
import math.geom3d.Point3D;

public class Box3D {
    private double xmin = 0.0;
    private double xmax = 0.0;
    private double ymin = 0.0;
    private double ymax = 0.0;
    private double zmin = 0.0;
    private double zmax = 0.0;

    public Box3D() {
        this(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public Box3D(double x0, double x1, double y0, double y1, double z0, double z1) {
        this.xmin = Math.min(x0, x1);
        this.xmax = Math.max(x0, x1);
        this.ymin = Math.min(y0, y1);
        this.ymax = Math.max(y0, y1);
        this.zmin = Math.min(z0, z1);
        this.zmax = Math.max(z0, z1);
    }

    public Box3D(Point3D p1, Point3D p2) {
        this(p1.getX(), p2.getX(), p1.getY(), p2.getY(), p1.getZ(), p2.getZ());
    }

    public Box3D(Tuple3d p1, Tuple3d p2) {
        this(p1.getX(), p2.getX(), p1.getY(), p2.getY(), p1.getZ(), p2.getZ());
    }

    public double getMinX() {
        return this.xmin;
    }

    public double getMaxX() {
        return this.xmax;
    }

    public double getMinY() {
        return this.ymin;
    }

    public double getMaxY() {
        return this.ymax;
    }

    public double getMinZ() {
        return this.zmin;
    }

    public double getMaxZ() {
        return this.zmax;
    }

    public double getWidth() {
        return this.xmax - this.xmin;
    }

    public double getHeight() {
        return this.ymax - this.ymin;
    }

    public double getDepth() {
        return this.zmax - this.zmin;
    }

    public Box3D union(Box3D box) {
        double xmin = Math.min(this.xmin, box.xmin);
        double xmax = Math.max(this.xmax, box.xmax);
        double ymin = Math.min(this.ymin, box.ymin);
        double ymax = Math.max(this.ymax, box.ymax);
        double zmin = Math.min(this.zmin, box.zmin);
        double zmax = Math.max(this.zmax, box.zmax);
        return new Box3D(xmin, xmax, ymin, ymax, zmin, zmax);
    }

    public Box3D intersection(Box3D box) {
        double xmin = Math.max(this.xmin, box.xmin);
        double xmax = Math.min(this.xmax, box.xmax);
        double ymin = Math.max(this.ymin, box.ymin);
        double ymax = Math.min(this.ymax, box.ymax);
        double zmin = Math.max(this.zmin, box.zmin);
        double zmax = Math.min(this.zmax, box.zmax);
        return new Box3D(xmin, xmax, ymin, ymax, zmin, zmax);
    }
}

