/*
 * Decompiled with CFR 0.152.
 */
package sk.stuba.fiit.pogamut.jungigation.layouts;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import org.apache.commons.collections15.Transformer;
import sk.stuba.fiit.pogamut.jungigation.objects.MyEdge;
import sk.stuba.fiit.pogamut.jungigation.objects.MyVertice;

public class Simple2DLayout
implements Layout<MyVertice, MyEdge> {
    private Graph<MyVertice, MyEdge> mygraph = null;
    private Dimension sizeForPloting = new Dimension(1000, 1000);
    private double scaleFactor = 1.0;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double minx = Double.MAX_VALUE;
    private double miny = Double.MAX_VALUE;
    private double maxx = Double.MIN_VALUE;
    private double maxy = Double.MIN_VALUE;

    public Simple2DLayout(Graph<MyVertice, MyEdge> g) {
        this.setGraph(g);
    }

    @Override
    public void initialize() {
    }

    @Override
    public void setInitializer(Transformer<MyVertice, Point2D> t) {
    }

    @Override
    public void setGraph(Graph<MyVertice, MyEdge> graph) {
        this.mygraph = graph;
        for (MyVertice vert : this.mygraph.getVertices()) {
            double x = vert.getLocation().getX();
            double y = vert.getLocation().getY();
            if (this.maxx < x) {
                this.maxx = x;
            }
            if (this.maxy < y) {
                this.maxy = y;
            }
            if (this.minx > x) {
                this.minx = x;
            }
            if (!(this.miny > y)) continue;
            this.miny = y;
        }
        this.recalculateScaleAndOffset();
    }

    @Override
    public Graph<MyVertice, MyEdge> getGraph() {
        return this.mygraph;
    }

    @Override
    public void reset() {
    }

    @Override
    public void setSize(Dimension dmnsn) {
        this.sizeForPloting = dmnsn;
        this.recalculateScaleAndOffset();
    }

    @Override
    public Dimension getSize() {
        return this.sizeForPloting;
    }

    @Override
    public void lock(MyVertice v, boolean bln) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isLocked(MyVertice v) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setLocation(MyVertice v, Point2D pd) {
    }

    @Override
    public Point2D transform(MyVertice i) {
        return new Point2D.Double((i.getLocation().x + this.offsetX) / this.scaleFactor, (i.getLocation().y + this.offsetY) / this.scaleFactor);
    }

    protected void recalculateScaleAndOffset() {
        double scaleY;
        double height = this.maxy - this.miny;
        double width = this.maxx - this.minx;
        double scaleX = this.getSize().getWidth() / width;
        this.scaleFactor = 1.2 / (scaleX > (scaleY = this.getSize().getHeight() / height) ? scaleY : scaleX);
        this.offsetX = 0.1 * width - this.minx;
        this.offsetY = 0.1 * height - this.miny;
    }
}

