/*
 * Decompiled with CFR 0.152.
 */
package sk.stuba.fiit.pogamut.jungigation.objects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import sk.stuba.fiit.pogamut.jungigation.transformers.SerializableByTransformer;

public class MyEdge
implements SerializableByTransformer {
    private ArrayList<Double> times = new ArrayList();
    private String id;
    private double travelTimeComputed = 0.0;

    public MyEdge(String id) {
        this.id = id;
    }

    public MyEdge(String id, double time2) {
        this.id = id;
        this.times.add(time2);
        this.travelTimeComputed = time2;
    }

    public MyEdge(String serializedID, String arraylist) {
        this.id = serializedID;
        this.deserialize(arraylist);
    }

    public MyEdge(double travelTime, int countOfTraveling) {
        for (int i = 0; i < countOfTraveling; ++i) {
            this.times.add(travelTime);
        }
        this.travelTimeComputed = 0.0;
    }

    public void addNewTravelTime(double time2) {
        this.times.add(time2);
        this.travelTimeComputed = 0.0;
    }

    public ArrayList<Double> getAllTravelTimes() {
        return this.times;
    }

    public double getTravelTime() {
        if (this.travelTimeComputed != 0.0) {
            return this.travelTimeComputed;
        }
        Collections.sort(this.times);
        int count = this.times.size();
        if (count == 0) {
            return Double.NaN;
        }
        if (count == 1) {
            return this.times.get(0);
        }
        this.travelTimeComputed = MyEdge.median(this.times.toArray(new Double[count]));
        return this.travelTimeComputed;
    }

    public int getNumberOfTravelsInArray() {
        return this.times.size();
    }

    public static double median(Double[] m) {
        int middle = m.length / 2;
        if (m.length % 2 == 1) {
            return m[middle];
        }
        return (m[middle - 1] + m[middle]) / 2.0;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        String a = this.id;
        return "MyEdge(" + a + "):" + this.getTravelTime();
    }

    @Override
    public String serialize() {
        String navrat = "";
        navrat = navrat + this.times.size();
        navrat = navrat + "#";
        for (Double time2 : this.times) {
            time2 = (double)Math.round(time2 * 1000.0) / 1000.0;
            navrat = navrat + time2;
            navrat = navrat + "#";
        }
        return navrat;
    }

    @Override
    public void deserialize(String data) {
        int count;
        StringTokenizer st = new StringTokenizer(data, "#");
        String countS = st.nextToken();
        try {
            count = Integer.parseInt(countS);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error while parsing stored edge data count from text (data=" + data + ")! Error:" + ex.getMessage(), ex);
        }
        this.times.clear();
        for (int j = 0; j < count; ++j) {
            try {
                this.addNewTravelTime(Double.parseDouble(st.nextToken()));
                continue;
            }
            catch (Exception ex) {
                throw new RuntimeException("Error while parsing stored edge data (times) from text (data=" + data + ")! Error:" + ex.getMessage(), ex);
            }
        }
    }

    public String getId() {
        return this.id;
    }
}

