/*
 * Decompiled with CFR 0.152.
 */
package sk.stuba.fiit.pogamut.jungigation.objects;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import java.util.Map;

public class MyVertice
implements Comparable<MyVertice>,
ILocated {
    private UnrealId id;
    private Location location;
    private String itemType;
    public double valueAdded = 0.0;
    private int spawnFor = -1;
    private int itemAmount;

    public MyVertice(NavPoint navPoint) {
        Item i;
        this.id = navPoint.getId();
        this.location = navPoint.getLocation();
        ItemType it = navPoint.getItemClass();
        this.itemType = it != null ? it.getName() : null;
        if (navPoint.isPlayerStart()) {
            this.spawnFor = navPoint.getTeamNumber();
        }
        this.itemAmount = (i = navPoint.getItemInstance()) != null ? i.getAmount() : -1;
    }

    public MyVertice(String serializedID, Map<String, String> map) {
        int spawnFor;
        int amount;
        double z;
        double y;
        double x;
        String locX = map.get("x");
        String locY = map.get("y");
        String locZ = map.get("z");
        String itemTypeS = map.get("ItemType");
        String itemAmountS = map.get("ItemAmount");
        String spawnForS = map.get("SpawnFor");
        try {
            x = Double.parseDouble(locX);
            y = Double.parseDouble(locY);
            z = Double.parseDouble(locZ);
            amount = itemAmountS == null ? -1 : Integer.parseInt(itemAmountS);
            spawnFor = spawnForS == null ? -1 : Integer.parseInt(spawnForS);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error while parsing stored location from text (itemTypeS=" + itemTypeS + ",itemAmountS=" + itemAmountS + ",locX=" + locX + ",locY=" + locY + ",locZ=" + locZ + ") to double! Error:" + ex.getMessage(), ex);
        }
        this.id = UnrealId.get(serializedID);
        this.location = new Location(x, y, z);
        this.itemType = itemTypeS == null ? null : itemTypeS;
        this.itemAmount = amount;
        this.spawnFor = spawnFor;
    }

    public MyVertice(String serializedID, Location location) {
        this.id = UnrealId.get(serializedID);
        this.location = location;
    }

    public final String getItemType() {
        return this.itemType;
    }

    public int getSpawnFor() {
        return this.spawnFor;
    }

    public final int getItemAmount() {
        return this.itemAmount;
    }

    public UnrealId getId() {
        return this.id;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public boolean equals(Object obj) {
        MyVertice objVer;
        return obj instanceof MyVertice && (objVer = (MyVertice)obj).getId().getStringId().toLowerCase().equals(this.getId().getStringId().toLowerCase()) && objVer.getLocation().equals(this.getLocation());
    }

    public String toString() {
        return "MyVertice:" + this.getId() + ",loc:" + this.location + ",ItemType:" + this.itemType + ",ItemAmount:" + this.itemAmount + ",valueAdded:" + this.valueAdded;
    }

    public int hashCode() {
        return this.id.getStringId().toLowerCase().hashCode();
    }

    @Override
    public int compareTo(MyVertice arg0) {
        if (this.equals(arg0)) {
            return 0;
        }
        int comp = this.id.getStringId().compareTo(arg0.id.getStringId());
        if (comp == 0) {
            System.err.println("TODO Probably ERROR!!! this=" + this.toString() + ";arg0=" + arg0);
        }
        return comp;
    }
}

