/*
 * Decompiled with CFR 0.152.
 */
package sk.stuba.fiit.pogamut.jungigation.pathPlanners;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import edu.uci.ics.jung.graph.Graph;
import java.util.Collection;
import java.util.List;
import jung.myalghoritm.MyShortestPath;
import sk.stuba.fiit.pogamut.jungigation.objects.MyEdge;
import sk.stuba.fiit.pogamut.jungigation.objects.MyVertice;
import sk.stuba.fiit.pogamut.jungigation.pathPlanners.EmptyPathHandle;
import sk.stuba.fiit.pogamut.jungigation.pathPlanners.JUNGPathHandle;

public class UniversalPathPlanner
implements IPathPlanner<ILocated>,
MyShortestPath<MyVertice, MyEdge> {
    private MyShortestPath<MyVertice, MyEdge> shortestPath;
    protected final Graph<MyVertice, MyEdge> navigationGraph;
    private final UT2004Bot bot;
    private final Collection<NavPoint> navpoints;

    public UniversalPathPlanner(Graph<MyVertice, MyEdge> g, UT2004Bot bot, Collection<NavPoint> navpoints, MyShortestPath<MyVertice, MyEdge> pathPlanner) {
        this.navigationGraph = g;
        this.bot = bot;
        this.navpoints = navpoints;
        this.shortestPath = pathPlanner;
    }

    public MyShortestPath<MyVertice, MyEdge> getShortestPath() {
        return this.shortestPath;
    }

    public void setShortestPath(MyShortestPath<MyVertice, MyEdge> shortestPath) {
        this.shortestPath = shortestPath;
    }

    public final IPathFuture<ILocated> computePath(ILocated to) {
        Location from = this.bot.getLocation();
        if (from == null) {
            return new EmptyPathHandle<ILocated>();
        }
        return this.computePath(from, to);
    }

    @Override
    public final IPathFuture<ILocated> computePath(ILocated from, ILocated to) {
        if (from == null) {
            return new EmptyPathHandle<ILocated>();
        }
        NavPoint fromN = DistanceUtils.getNearest(this.navpoints, from);
        NavPoint toN = to instanceof NavPoint ? (NavPoint)to : DistanceUtils.getNearest(this.navpoints, to);
        if (fromN == null || toN == null) {
            throw new RuntimeException("From or To navpoint is null!", new NullPointerException("Could not get nearest nav point. It is null!"));
        }
        List<MyEdge> path = this.computePathInternal(fromN, toN);
        JUNGPathHandle navrat = new JUNGPathHandle(path, this.navigationGraph, this.navpoints);
        return navrat;
    }

    public List<MyEdge> computePathInternal(NavPoint from, NavPoint to) {
        List<MyEdge> path;
        try {
            path = this.getPath(new MyVertice(from), new MyVertice(to));
        }
        catch (Exception ex) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException ex1) {
                // empty catch block
            }
            path = this.getPath(new MyVertice(from), new MyVertice(to));
        }
        return path;
    }

    @Override
    public List<MyEdge> getPath(MyVertice source, MyVertice target) {
        return this.shortestPath.getPath(source, target);
    }
}

