/*
 * Decompiled with CFR 0.152.
 */
package sk.stuba.fiit.pogamut.jungigation.pathPlanners.helpers;

import edu.uci.ics.jung.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jung.myalghoritm.dynamicWeigths.EdgeAndVertexToNumberWeightTransformer;
import jung.myalghoritm.dynamicWeigths.WeigthForItem;
import org.apache.commons.collections15.Transformer;
import org.apache.log4j.Logger;
import sk.stuba.fiit.pogamut.jungigation.objects.MyEdge;
import sk.stuba.fiit.pogamut.jungigation.objects.MyVertice;
import sk.stuba.fiit.pogamut.jungigation.transformers.EdgeToTimeNumberTransformer;

public class EdgeAndVertexToNumberAdvancedTransformer
extends EdgeAndVertexToNumberWeightTransformer<MyVertice, MyEdge> {
    private static final Logger log = Logger.getLogger(EdgeAndVertexToNumberAdvancedTransformer.class);
    private Map<MyVertice, WeigthForItem> currentMapOfItemInterest;
    private final Map<String, Map<MyVertice, WeigthForItem>> mapsOfWeights = new HashMap<String, Map<MyVertice, WeigthForItem>>();
    public static final String HEALTHINTEREST = "HealthInterest";
    public static final String ARMORINTEREST = "ArmorInterest";
    public static final String JUSTTIMEINTEREST = "JustTimeInterest";
    private Transformer<MyVertice, Number> verticeTransformer = new Transformer<MyVertice, Number>(){

        @Override
        public Number transform(MyVertice input) {
            double navrat = input.valueAdded;
            WeigthForItem weigthForItem = (WeigthForItem)EdgeAndVertexToNumberAdvancedTransformer.this.currentMapOfItemInterest.get(input);
            if (weigthForItem != null) {
                navrat -= (double)weigthForItem.getOffsetAdd();
                if (input.getItemAmount() != -1) {
                    navrat -= (double)(weigthForItem.getAmountMultiplier() * (float)input.getItemAmount());
                }
            }
            if (Double.isInfinite(navrat) || Double.isNaN(navrat)) {
                log.warn("Vertex had no number value! Edge: " + input);
            }
            return navrat;
        }
    };

    public EdgeAndVertexToNumberAdvancedTransformer(Graph<MyVertice, MyEdge> navigationGraph) {
        this(navigationGraph, null);
    }

    public EdgeAndVertexToNumberAdvancedTransformer(Graph<MyVertice, MyEdge> navigationGraph, Map<MyVertice, WeigthForItem> mapOfItemInterest) {
        super(navigationGraph, null, new EdgeToTimeNumberTransformer());
        this.currentMapOfItemInterest = mapOfItemInterest;
        this.setCurrentTransformerInterestForVertex(this.verticeTransformer);
        if (navigationGraph == null) {
            System.out.println("navigationGraph is null. No profile will be created!");
        } else {
            this.putNewProfile(HEALTHINTEREST, EdgeAndVertexToNumberAdvancedTransformer.getHealthInterestMapForNavpoints(this.navigationGraph));
            this.putNewProfile(ARMORINTEREST, EdgeAndVertexToNumberAdvancedTransformer.getArmorInterestMapForNavpoints(this.navigationGraph));
            this.putNewProfile(JUSTTIMEINTEREST, EdgeAndVertexToNumberAdvancedTransformer.getJustTimeInterestMapForNavpoints(this.navigationGraph));
            this.setActiveProfile(ARMORINTEREST);
        }
    }

    public boolean setActiveProfile(String profileName) {
        Map<MyVertice, WeigthForItem> profileMapOfInterest = this.mapsOfWeights.get(profileName);
        if (profileMapOfInterest == null) {
            return false;
        }
        this.currentMapOfItemInterest = profileMapOfInterest;
        return true;
    }

    public boolean putNewProfile(String profileName, Map<MyVertice, WeigthForItem> profileInterestMap) {
        return this.mapsOfWeights.put(profileName, profileInterestMap) == null;
    }

    public static Map<MyVertice, WeigthForItem> getHealthInterestMapForNavpoints(Graph<MyVertice, MyEdge> navigationGraph) {
        HashMap<MyVertice, WeigthForItem> navrat = new HashMap<MyVertice, WeigthForItem>();
        Collection vertices = navigationGraph.getVertices();
        for (MyVertice vertice : vertices) {
            String itemType = vertice.getItemType();
            if (itemType == null) continue;
            if (itemType.equals("XPickups.HealthPack") || itemType.equals("XPickups.MiniHealthPack")) {
                navrat.put(vertice, new WeigthForItem(0.17f, 50.0f));
                continue;
            }
            if (itemType.equals("XPickups.AdrenalinePickup")) {
                navrat.put(vertice, new WeigthForItem(1.0f, 1.0f));
                continue;
            }
            if (itemType.equals("XPickups.SuperShieldPack")) {
                navrat.put(vertice, new WeigthForItem(0.1f, 3.0f));
                continue;
            }
            if (!itemType.equals("XPickups.ShieldPack")) continue;
            navrat.put(vertice, new WeigthForItem(0.1f, 3.0f));
        }
        return navrat;
    }

    public static Map<MyVertice, WeigthForItem> getJustTimeInterestMapForNavpoints(Graph<MyVertice, MyEdge> navigationGraph) {
        HashMap<MyVertice, WeigthForItem> navrat = new HashMap<MyVertice, WeigthForItem>();
        return navrat;
    }

    public static Map<MyVertice, WeigthForItem> getArmorInterestMapForNavpoints(Graph<MyVertice, MyEdge> navigationGraph) {
        HashMap<MyVertice, WeigthForItem> navrat = new HashMap<MyVertice, WeigthForItem>();
        ArrayList vertices = new ArrayList(navigationGraph.getVertices());
        for (MyVertice vertice : vertices) {
            String itemType = vertice.getItemType();
            if (itemType == null) continue;
            if (itemType.equals("XPickups.HealthPack") || itemType.equals("XPickups.MiniHealthPack")) {
                navrat.put(vertice, new WeigthForItem(0.17f, 1.0f));
                continue;
            }
            if (itemType.equals("XPickups.AdrenalinePickup")) {
                navrat.put(vertice, new WeigthForItem(1.0f, 1.0f));
                continue;
            }
            if (itemType.equals("XPickups.SuperShieldPack")) {
                navrat.put(vertice, new WeigthForItem(0.15f, 4.0f));
                continue;
            }
            if (!itemType.equals("XPickups.ShieldPack")) continue;
            navrat.put(vertice, new WeigthForItem(0.15f, 2.0f));
        }
        return navrat;
    }

    public static Map<MyVertice, WeigthForItem> getMachinegunInterestMapForNavpoints(Graph<MyVertice, MyEdge> navigationGraph) {
        HashMap<MyVertice, WeigthForItem> navrat = new HashMap<MyVertice, WeigthForItem>();
        ArrayList vertices = new ArrayList(navigationGraph.getVertices());
        for (MyVertice vertice : vertices) {
            String itemType = vertice.getItemType();
            if (itemType == null) continue;
            if (itemType.equals("XPickups.HealthPack") || itemType.equals("XPickups.MiniHealthPack")) {
                navrat.put(vertice, new WeigthForItem(0.17f, 1.0f));
                continue;
            }
            if (itemType.equals("XPickups.AdrenalinePickup")) {
                navrat.put(vertice, new WeigthForItem(1.0f, 1.0f));
                continue;
            }
            if (itemType.equals("XPickups.SuperShieldPack")) {
                navrat.put(vertice, new WeigthForItem(0.1f, 19.0f));
                continue;
            }
            if (!itemType.equals("XPickups.ShieldPack")) continue;
            navrat.put(vertice, new WeigthForItem(0.1f, 12.0f));
        }
        return navrat;
    }
}

