/*
 * Decompiled with CFR 0.152.
 */
package sk.stuba.fiit.pogamut.jungigation.pathPlanners.helpers;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import edu.uci.ics.jung.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections15.Transformer;
import org.apache.log4j.Logger;
import sk.stuba.fiit.pogamut.jungigation.objects.MyEdge;
import sk.stuba.fiit.pogamut.jungigation.objects.MyVertice;
import sk.stuba.fiit.pogamut.jungigation.pathPlanners.helpers.WeigthForItem;

public class EdgeToNumberAdvancedTransformer
implements Transformer<MyEdge, Number> {
    private static final Logger log = Logger.getLogger(EdgeToNumberAdvancedTransformer.class);
    private Map<MyVertice, WeigthForItem> mapOfItemInterest;
    private final Graph<MyVertice, MyEdge> navigationGraph;

    public EdgeToNumberAdvancedTransformer(Graph<MyVertice, MyEdge> navigationGraph, Map<MyVertice, WeigthForItem> mapOfItemInterest) {
        this.mapOfItemInterest = mapOfItemInterest;
        this.navigationGraph = navigationGraph;
    }

    @Override
    public Number transform(MyEdge edge) {
        double navrat = 0.7;
        double travelTime = edge.getTravelTime();
        if (Double.isNaN(travelTime)) {
            travelTime = 1000.0;
        }
        navrat += travelTime;
        MyVertice endVertice = this.navigationGraph.getDest(edge);
        WeigthForItem weigthForItem = this.mapOfItemInterest.get(endVertice);
        if (weigthForItem != null) {
            navrat -= (double)weigthForItem.getOffsetAdd();
            if (endVertice.getItemAmount() != -1) {
                navrat -= (double)(weigthForItem.getAmountMultiplier() * (float)endVertice.getItemAmount());
            }
        }
        if (Double.isInfinite(navrat) || Double.isNaN(navrat)) {
            log.warn("Edge had no number value! Edge: " + edge);
        }
        return navrat;
    }

    public void setNewMapInterest(Map<MyVertice, WeigthForItem> mapOfItemInterest) {
        this.mapOfItemInterest = mapOfItemInterest;
    }

    public static Map<MyVertice, WeigthForItem> getHealthInterestMapForNavpoints(Graph<MyVertice, MyEdge> navigationGraph, Collection<NavPoint> navpoints) {
        HashMap<MyVertice, WeigthForItem> navrat = new HashMap<MyVertice, WeigthForItem>();
        Collection vertices = navigationGraph.getVertices();
        for (MyVertice vertice : vertices) {
            String itemType = vertice.getItemType();
            if (itemType == null) continue;
            if (itemType.equals("XPickups.HealthPack")) {
                navrat.put(vertice, new WeigthForItem(0.17f, 50.0f));
                continue;
            }
            if (itemType.equals("XPickups.MiniHealthPack")) {
                navrat.put(vertice, new WeigthForItem(0.8f, 15.0f));
                continue;
            }
            if (itemType.equals("XPickups.AdrenalinePickup")) {
                navrat.put(vertice, new WeigthForItem(1.0f, 1.0f));
                continue;
            }
            if (itemType.equals("XPickups.SuperShieldPack")) {
                navrat.put(vertice, new WeigthForItem(0.1f, 19.0f));
                continue;
            }
            if (!itemType.equals("XPickups.ShieldPack")) continue;
            navrat.put(vertice, new WeigthForItem(0.1f, 12.0f));
        }
        return navrat;
    }

    public static Map<MyVertice, WeigthForItem> getJustTimeInterestMapForNavpoints(Graph<MyVertice, MyEdge> navigationGraph) {
        HashMap<MyVertice, WeigthForItem> navrat = new HashMap<MyVertice, WeigthForItem>();
        return navrat;
    }

    public static Map<MyVertice, WeigthForItem> getArmorInterestMapForNavpoints(Graph<MyVertice, MyEdge> navigationGraph) {
        HashMap<MyVertice, WeigthForItem> navrat = new HashMap<MyVertice, WeigthForItem>();
        ArrayList vertices = new ArrayList(navigationGraph.getVertices());
        for (MyVertice vertice : vertices) {
            String itemType = vertice.getItemType();
            if (itemType == null) continue;
            if (vertice.getId().toString().toLowerCase().contains("pot101") || vertice.getId().toString().toLowerCase().contains("pot96")) {
                navrat.put(vertice, new WeigthForItem(0.1f, 4.0f));
                continue;
            }
            if (itemType.equals("XPickups.HealthPack")) {
                navrat.put(vertice, new WeigthForItem(0.17f, 1.0f));
                continue;
            }
            if (itemType.equals("XPickups.MiniHealthPack")) {
                navrat.put(vertice, new WeigthForItem(0.8f, 2.0f));
                continue;
            }
            if (itemType.equals("XPickups.AdrenalinePickup")) {
                navrat.put(vertice, new WeigthForItem(1.0f, 1.0f));
                continue;
            }
            if (itemType.equals("XPickups.SuperShieldPack")) {
                navrat.put(vertice, new WeigthForItem(0.1f, 19.0f));
                continue;
            }
            if (!itemType.equals("XPickups.ShieldPack")) continue;
            navrat.put(vertice, new WeigthForItem(0.1f, 12.0f));
        }
        return navrat;
    }

    public static Map<MyVertice, WeigthForItem> getMachinegunInterestMapForNavpoints(Graph<MyVertice, MyEdge> navigationGraph) {
        HashMap<MyVertice, WeigthForItem> navrat = new HashMap<MyVertice, WeigthForItem>();
        ArrayList vertices = new ArrayList(navigationGraph.getVertices());
        for (MyVertice vertice : vertices) {
            String itemType = vertice.getItemType();
            if (itemType == null) continue;
            if (itemType.equals("XPickups.HealthPack")) {
                navrat.put(vertice, new WeigthForItem(0.17f, 1.0f));
                continue;
            }
            if (itemType.equals("XPickups.MiniHealthPack")) {
                navrat.put(vertice, new WeigthForItem(0.8f, 2.0f));
                continue;
            }
            if (itemType.equals("XPickups.AdrenalinePickup")) {
                navrat.put(vertice, new WeigthForItem(1.0f, 1.0f));
                continue;
            }
            if (itemType.equals("XPickups.SuperShieldPack")) {
                navrat.put(vertice, new WeigthForItem(0.1f, 19.0f));
                continue;
            }
            if (!itemType.equals("XPickups.ShieldPack")) continue;
            navrat.put(vertice, new WeigthForItem(0.1f, 12.0f));
        }
        return navrat;
    }
}

