/*
 * Decompiled with CFR 0.152.
 */
package sk.stuba.fiit.pogamut.jungigation.transformers;

import edu.uci.ics.jung.io.graphml.GraphMetadata;
import java.util.Map;
import org.apache.commons.collections15.Transformer;
import org.apache.log4j.Logger;
import sk.stuba.fiit.pogamut.jungigation.objects.NavigationGraphSynchronized;

public class MetadataGraphTransformer
implements Transformer<NavigationGraphSynchronized, GraphMetadata> {
    private static final Logger log = Logger.getLogger(MetadataGraphTransformer.class);

    @Override
    public GraphMetadata transform(NavigationGraphSynchronized graph) {
        GraphMetadata gm = new GraphMetadata();
        switch (graph.getDefaultEdgeType()) {
            case DIRECTED: {
                gm.setEdgeDefault(GraphMetadata.EdgeDefault.DIRECTED);
                break;
            }
            case UNDIRECTED: {
                gm.setEdgeDefault(GraphMetadata.EdgeDefault.UNDIRECTED);
                break;
            }
            default: {
                throw new RuntimeException("Graph method getDefaultEdgeType() returned unknown value! Value=" + (Object)((Object)graph.getDefaultEdgeType()) + ".");
            }
        }
        gm.setGraph(graph);
        try {
            gm.setProperty("LearningTime", Double.toString(graph.getLearningTime()));
            gm.setProperty("StucksCount", Long.toString(graph.getStucksCount()));
            gm.setProperty("RespawnCount", Long.toString(graph.getRespawnCount()));
        }
        catch (Exception ex) {
            log.error("Error while setting some property! Error:" + ex.getMessage(), ex);
        }
        for (Map.Entry<String, String> entry : graph.getAdditionalProperties().entrySet()) {
            try {
                gm.setProperty(entry.getKey(), entry.getValue());
            }
            catch (Exception ex) {
                log.error("Error while setting additional property ( - ). Error:" + ex.getMessage(), ex);
            }
        }
        return gm;
    }
}

