/*
 * Decompiled with CFR 0.152.
 */
package sk.stuba.fiit.pogamut.jungigation.visualization;

import edu.uci.ics.jung.algorithms.filters.EdgePredicateFilter;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.GraphMouseListener;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.PickingGraphMousePlugin;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.Transformer;
import sk.stuba.fiit.pogamut.jungigation.layouts.Simple2DLayout;
import sk.stuba.fiit.pogamut.jungigation.objects.MyEdge;
import sk.stuba.fiit.pogamut.jungigation.objects.MyVertice;
import sk.stuba.fiit.pogamut.jungigation.objects.NavigationGraphProviderForMap;
import sk.stuba.fiit.pogamut.jungigation.objects.NavigationGraphSynchronized;
import sk.stuba.fiit.pogamut.jungigation.pathPlanners.AdvancedPathPlanner;
import sk.stuba.fiit.pogamut.jungigation.transformers.EdgeToPaintTransformer;
import sk.stuba.fiit.pogamut.jungigation.transformers.EdgeToSimpleInfoStringTransformer;

public class GraphVisualizer
extends JFrame {
    private JMenuItem aboutMenuItem;
    private JMenuItem contentsMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem cutMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenu editMenu;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JFileChooser jFileChooser_gml;
    private JMenuBar menuBar;
    private JMenuItem openMenuItem;
    private JMenuItem pasteMenuItem;
    private JMenuItem saveAsMenuItem;
    private JMenuItem saveMenuItem;

    public GraphVisualizer() {
        this.initComponents();
    }

    private void initComponents() {
        this.jFileChooser_gml = new JFileChooser();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.cutMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.deleteMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.contentsMenuItem = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.jFileChooser_gml.setCurrentDirectory(null);
        this.jFileChooser_gml.setDialogTitle("Chose which gml file to open");
        this.setDefaultCloseOperation(3);
        this.fileMenu.setText("File");
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openMenuItem.setText("Open");
        this.openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphVisualizer.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.saveMenuItem.setText("Save");
        this.fileMenu.add(this.saveMenuItem);
        this.saveAsMenuItem.setText("Save As ...");
        this.fileMenu.add(this.saveAsMenuItem);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphVisualizer.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.cutMenuItem.setText("Cut");
        this.editMenu.add(this.cutMenuItem);
        this.copyMenuItem.setText("Copy");
        this.editMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setText("Paste");
        this.editMenu.add(this.pasteMenuItem);
        this.deleteMenuItem.setText("Delete");
        this.editMenu.add(this.deleteMenuItem);
        this.menuBar.add(this.editMenu);
        this.helpMenu.setText("Help");
        this.contentsMenuItem.setText("Contents");
        this.helpMenu.add(this.contentsMenuItem);
        this.aboutMenuItem.setText("About");
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 279, Short.MAX_VALUE));
        this.pack();
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        File defolt = new File("D:\\LuVar\\eWorkspace\\Iexplorer6\\");
        this.jFileChooser_gml.setCurrentDirectory(defolt);
        int navrat = this.jFileChooser_gml.showOpenDialog(this);
        if (navrat != 0) {
            System.out.println("User abborted opening!");
            return;
        }
        File fileToBeOpenned = this.jFileChooser_gml.getSelectedFile();
        final NavigationGraphSynchronized gOriginal = new NavigationGraphProviderForMap("nothing"){

            public NavigationGraphSynchronized getGraphFromFileMY(String filename) {
                return NavigationGraphProviderForMap.getGraphFromFile(filename);
            }
        }.getGraphFromFileMY(fileToBeOpenned.getAbsolutePath());
        Predicate<MyEdge> predicate = new Predicate<MyEdge>(){

            @Override
            public boolean evaluate(MyEdge t) {
                return t.getNumberOfTravelsInArray() != 0;
            }
        };
        EdgePredicateFilter<MyVertice, MyEdge> epf = new EdgePredicateFilter<MyVertice, MyEdge>(predicate);
        int totalEdgesCount = gOriginal.getEdgeCount();
        int totalVerticesCount = gOriginal.getVertexCount();
        NavigationGraphSynchronized g = epf.transform(gOriginal);
        int filteredCount = g.getEdgeCount();
        float percentage = (float)Math.round((float)filteredCount / (float)totalEdgesCount * 10000.0f) / 100.0f;
        System.out.println("Edges count ater filtering:" + filteredCount + ",beforeFiltering:" + totalEdgesCount + ". It is:" + percentage + "%.");
        double graphDensity = 2.0 * (double)totalEdgesCount / (double)(totalVerticesCount * (totalVerticesCount - 1));
        System.out.println("Vertices: " + gOriginal.getVertexCount() + ",\t edges: " + totalEdgesCount + ",\t graphDensity: " + graphDensity);
        g = gOriginal;
        Simple2DLayout layout = new Simple2DLayout(g);
        layout.setSize(new Dimension(1500, 950));
        final VisualizationViewer<MyVertice, MyEdge> vv = new VisualizationViewer<MyVertice, MyEdge>(layout);
        vv.setPreferredSize(new Dimension(350, 350));
        vv.getRenderContext().setEdgeLabelTransformer(new EdgeToSimpleInfoStringTransformer());
        vv.getRenderContext().setEdgeDrawPaintTransformer(new EdgeToPaintTransformer());
        vv.getRenderContext().setVertexLabelTransformer(new Transformer<MyVertice, String>(){

            @Override
            public String transform(MyVertice i) {
                String aaa = i.getId().getStringId();
                if ((aaa = aaa.substring(aaa.indexOf(".") + 1, aaa.length())).toLowerCase().contains("flag")) {
                    return aaa;
                }
                if (aaa.toLowerCase().contains("inventoryspot")) {
                    return aaa;
                }
                return "";
            }
        });
        DefaultModalGraphMouse gm = new DefaultModalGraphMouse();
        gm.setMode(ModalGraphMouse.Mode.TRANSFORMING);
        vv.setGraphMouse(gm);
        PickingGraphMousePlugin pgmp = new PickingGraphMousePlugin();
        gm.add(pgmp);
        final AdvancedPathPlanner dsp = new AdvancedPathPlanner(g, null, null);
        vv.addGraphMouseListener(new GraphMouseListener(){

            public void graphClicked(Object v, MouseEvent me) {
                try {
                    Set pickedE = vv.getPickedEdgeState().getPicked();
                    if (pickedE.size() == 1) {
                        MyVertice mv = (MyVertice)gOriginal.getDest(pickedE.iterator().next());
                        vv.getPickedVertexState().pick(mv, true);
                        return;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                try {
                    List<MyEdge> path;
                    Set picked = vv.getPickedVertexState().getPicked();
                    Iterator it = picked.iterator();
                    MyVertice from = (MyVertice)it.next();
                    MyVertice to = (MyVertice)it.next();
                    try {
                        path = dsp.getPath(from, to);
                    }
                    catch (Exception ex) {
                        System.out.println(ex.getMessage());
                        ex.printStackTrace();
                        throw ex;
                    }
                    for (MyEdge myEdge : path) {
                        vv.getPickedEdgeState().pick(myEdge, true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void graphPressed(Object v, MouseEvent me) {
            }

            public void graphReleased(Object v, MouseEvent me) {
            }
        });
        JFrame frame = new JFrame("Simple Graph View");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(vv);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new GraphVisualizer().setVisible(true);
            }
        });
    }
}

