/*
 * Decompiled with CFR 0.152.
 */
package sk.stuba.fiit.pogamut.jungigation.worldInfo;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.MapPointListObtained;
import cz.cuni.amis.utils.maps.HashMapMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class SharedItems {
    private ItemMaps items = new ItemMaps();
    private PlayerMaps players = new PlayerMaps();
    protected List<ItemsListener> itemsListener = new ArrayList<ItemsListener>();
    protected List<PlayersListener> playersListener = new ArrayList<PlayersListener>();
    protected List<SelfListener> selfListener = new ArrayList<SelfListener>();
    protected List<MapPointsListener> mapPointsListener = new ArrayList<MapPointsListener>();
    protected final Set<IWorldView> worldView = Collections.synchronizedSet(new HashSet());

    public Map<UnrealId, Item> getAllItems() {
        return Collections.unmodifiableMap(this.items.all);
    }

    public Map<UnrealId, Player> getAllPlayers() {
        return Collections.unmodifiableMap(this.players.allPlayers);
    }

    public Map<UnrealId, Self> getAllSelfs() {
        return Collections.unmodifiableMap(this.players.allSelfs);
    }

    public Map<UnrealId, Item> getAllItems(ItemType type) {
        return Collections.unmodifiableMap(this.items.allCategories.get(type));
    }

    public Item getItem(UnrealId id) {
        Item item = (Item)this.items.all.get(id);
        if (item == null) {
            item = (Item)this.items.visible.get(id);
        }
        return item;
    }

    public Item getItem(String stringUnrealId) {
        return this.getItem(UnrealId.get(stringUnrealId));
    }

    public Map<UnrealId, Item> getVisibleItems() {
        return Collections.unmodifiableMap(this.items.visible);
    }

    public Map<UnrealId, Item> getVisibleItems(ItemType type) {
        return Collections.unmodifiableMap(this.items.visibleCategories.get(type));
    }

    public Item getVisibleItem(UnrealId id) {
        Item item = (Item)this.items.visible.get(id);
        return item;
    }

    public Item getVisibleItem(String stringUnrealId) {
        return this.getVisibleItem(UnrealId.get(stringUnrealId));
    }

    public Map<UnrealId, Item> getReachableItems() {
        return Collections.unmodifiableMap(this.items.reachable);
    }

    public Map<UnrealId, Item> getReachableItems(ItemType type) {
        return Collections.unmodifiableMap(this.items.reachableCategories.get(type));
    }

    public Item getReachableItem(UnrealId id) {
        Item item = (Item)this.items.reachable.get(id);
        if (item == null && !(item = (Item)this.items.visible.get(id)).isReachable()) {
            return null;
        }
        return item;
    }

    public Item getReachableItem(String stringUnrealId) {
        return this.getReachableItem(UnrealId.get(stringUnrealId));
    }

    public Map<UnrealId, Item> getKnownPickups() {
        return Collections.unmodifiableMap(this.items.known);
    }

    public Map<UnrealId, Item> getKnownPickups(ItemType type) {
        return Collections.unmodifiableMap(this.items.knownCategories.get(type));
    }

    public Item getKnownPickup(UnrealId id) {
        return (Item)this.items.known.get(id);
    }

    public Item getKnownPickup(String stringUnrealId) {
        return this.getKnownPickup(UnrealId.get(stringUnrealId));
    }

    public boolean isPickupSpawned(Item item) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public SharedItems(IVisionWorldView worldView) {
        this(worldView, null);
    }

    public SharedItems(IWorldView worldView, Logger log) {
        this.worldView.add(worldView);
        this.itemsListener.add(new ItemsListener(worldView));
        this.mapPointsListener.add(new MapPointsListener(worldView));
        this.playersListener.add(new PlayersListener(worldView));
        this.selfListener.add(new SelfListener(worldView));
    }

    public Set<IWorldView> getWorldView() {
        return this.worldView;
    }

    public void addMoreWorldView(IWorldView worldView) {
        if (this.worldView.contains(worldView)) {
            return;
        }
        this.worldView.add(worldView);
        this.itemsListener.add(new ItemsListener(worldView));
        this.mapPointsListener.add(new MapPointsListener(worldView));
        this.playersListener.add(new PlayersListener(worldView));
        this.selfListener.add(new SelfListener(worldView));
    }

    public void removeWorldView(IWorldView worldView) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    protected class MapPointsListener
    implements IWorldEventListener<MapPointListObtained> {
        private final IWorldView worldView;

        public MapPointsListener(IWorldView worldView) {
            this.worldView = worldView;
            this.worldView.addEventListener(MapPointListObtained.class, this);
        }

        @Override
        public void notify(MapPointListObtained event) {
            SharedItems.this.items.notify(event.getItems());
            this.worldView.removeEventListener(MapPointListObtained.class, this);
        }
    }

    protected class ItemsListener
    implements IWorldObjectListener<Item> {
        public ItemsListener(IWorldView worldView) {
            worldView.addObjectListener(Item.class, WorldObjectUpdatedEvent.class, this);
        }

        @Override
        public void notify(IWorldObjectEvent<Item> event) {
            SharedItems.this.items.notify(event.getObject());
        }
    }

    protected class SelfListener
    implements IWorldObjectListener<Self> {
        public SelfListener(IWorldView worldView) {
            worldView.addObjectListener(Self.class, WorldObjectUpdatedEvent.class, this);
        }

        @Override
        public void notify(IWorldObjectEvent<Self> event) {
            SharedItems.this.players.notify(event.getObject());
        }
    }

    protected class PlayersListener
    implements IWorldObjectListener<Player> {
        public PlayersListener(IWorldView worldView) {
            worldView.addObjectListener(Player.class, WorldObjectUpdatedEvent.class, this);
        }

        @Override
        public void notify(IWorldObjectEvent<Player> event) {
            SharedItems.this.players.notify(event.getObject());
        }
    }

    private class PlayerMaps {
        private HashMap<UnrealId, Player> allPlayers = new HashMap();
        private HashMap<UnrealId, Self> allSelfs = new HashMap();

        private PlayerMaps() {
        }

        private void notify(Player player) {
            UnrealId uid = player.getId();
            if (!this.allPlayers.containsKey(uid)) {
                this.allPlayers.put(uid, player);
            }
        }

        private void notify(Self player) {
            UnrealId uid = player.getId();
            if (!this.allSelfs.containsKey(uid)) {
                this.allSelfs.put(uid, player);
            }
        }
    }

    private class ItemMaps {
        private HashMap<UnrealId, Item> all = new HashMap();
        private HashMap<UnrealId, Item> visible = new HashMap();
        private HashMap<UnrealId, Item> reachable = new HashMap();
        private HashMap<UnrealId, Item> known = new HashMap();
        private HashMapMap<ItemType, UnrealId, Item> allCategories = new HashMapMap();
        private HashMapMap<ItemType, UnrealId, Item> visibleCategories = new HashMapMap();
        private HashMapMap<ItemType, UnrealId, Item> reachableCategories = new HashMapMap();
        private HashMapMap<ItemType, UnrealId, Item> knownCategories = new HashMapMap();

        private ItemMaps() {
        }

        private void notify(Item item) {
            UnrealId uid = item.getId();
            if (!this.all.containsKey(uid)) {
                this.all.put(uid, item);
                this.allCategories.put(item.getType(), item.getId(), item);
            }
            boolean wasVisible = this.visible.containsKey(uid);
            boolean isVisible = item.isVisible();
            if (isVisible && !wasVisible) {
                this.visible.put(uid, item);
                this.visibleCategories.put(item.getType(), item.getId(), item);
            } else if (!isVisible && wasVisible) {
                this.visible.remove(uid);
                this.visibleCategories.remove(item.getType(), item.getId());
            }
            if (!isVisible && item.isDropped()) {
                this.all.remove(uid);
                this.allCategories.remove(item.getType(), item.getId());
            }
            boolean wasReachable = this.reachable.containsKey(uid);
            boolean isReachable = item.isReachable();
            if (isReachable && !wasReachable) {
                this.reachable.put(uid, item);
                this.reachableCategories.put(item.getType(), item.getId(), item);
            } else if (!isReachable && wasReachable) {
                this.reachable.remove(uid);
                this.reachableCategories.remove(item.getType(), item.getId());
            }
        }

        private void notify(Map<UnrealId, Item> items) {
            this.known.putAll(items);
            for (Item item : items.values()) {
                this.knownCategories.put(item.getType(), item.getId(), item);
            }
        }
    }
}

