/*
 * Decompiled with CFR 0.152.
 */
package sk.stuba.fiit.pogamut.jungigation.worldInfo.objects;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.GameTime;

public abstract class ProbhetObjectVisionStatic {
    protected final UnrealId id;
    private double lastSeenTime = -10.0;
    protected Set<Map.Entry<Location, Double>> location;

    public ProbhetObjectVisionStatic(UnrealId id, Set<Map.Entry<Location, Double>> location) {
        this.id = id;
        this.setFuzzyLocation(location);
    }

    public UnrealId getId() {
        return this.id;
    }

    public double getLastSeenTime() {
        return this.lastSeenTime;
    }

    public void setLastSeenTime(double lastSeenTime) {
        this.lastSeenTime = lastSeenTime;
    }

    public double getAge() {
        return GameTime.actualTime - this.lastSeenTime;
    }

    public Map.Entry<Location, Double> getMostProbableLocation() {
        double maximum = Double.MIN_VALUE;
        Map.Entry<Location, Double> mostProbableLocation = null;
        for (Map.Entry<Location, Double> loc : this.location) {
            if (!(loc.getValue() > maximum)) continue;
            mostProbableLocation = loc;
            maximum = loc.getValue();
        }
        return mostProbableLocation;
    }

    public Set<Map.Entry<Location, Double>> getFuzzyLocation() {
        return Collections.unmodifiableSet(this.location);
    }

    public void setFuzzyLocation(Set<Map.Entry<Location, Double>> location) {
        if (location == null) {
            throw new RuntimeException("Location should not be null! " + this.getClass().getName());
        }
        if (location.size() == 0) {
            throw new RuntimeException("Location should not have size 0! " + this.getClass().getName());
        }
        this.location = location;
    }
}

