/*
 * Decompiled with CFR 0.152.
 */
package sk.stuba.fiit.pogamut.jungigation.worldInfo.objectsCache;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objectsCache.CacheInterface;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.snapshoot.ItemSnapshoot;

public class ItemsCache
implements CacheInterface {
    private Map<IWorldView, ItemsListener> listeners = new HashMap<IWorldView, ItemsListener>();
    private Map<UnrealId, List<ItemSnapshoot>> itemsHistory = Collections.synchronizedMap(new HashMap());
    public static final int HISTORYSIZE = 10;

    public ItemsCache(IWorldView worldView) {
        ItemsListener tmp = new ItemsListener();
        this.listeners.put(worldView, tmp);
        worldView.addObjectListener(Item.class, tmp);
    }

    @Override
    public void addAnotherViewer(IWorldView worldView) {
        ItemsListener tmp = new ItemsListener();
        this.listeners.put(worldView, tmp);
        worldView.addObjectListener(Item.class, WorldObjectUpdatedEvent.class, tmp);
    }

    @Override
    public void removeViewer(IWorldView worldView) {
        ItemsListener tmp = this.listeners.get(worldView);
        this.listeners.remove(worldView);
        worldView.removeObjectListener(Item.class, WorldObjectUpdatedEvent.class, tmp);
    }

    public List<ItemSnapshoot> getItemHistory(UnrealId id) {
        return Collections.unmodifiableList(this.itemsHistory.get(id));
    }

    public Map<UnrealId, List<ItemSnapshoot>> getItemsHistory() {
        return Collections.unmodifiableMap(this.itemsHistory);
    }

    protected void notify(Item event) {
        List<ItemSnapshoot> oneItemHistory = this.itemsHistory.get(event.getId());
        if (oneItemHistory == null) {
            oneItemHistory = Collections.synchronizedList(new LinkedList());
            this.itemsHistory.put(event.getId(), oneItemHistory);
        }
        oneItemHistory.add(0, new ItemSnapshoot(event));
        while (oneItemHistory.size() > 10) {
            oneItemHistory.remove(10);
        }
    }

    private class ItemsListener
    implements IWorldObjectListener<Item> {
        private ItemsListener() {
        }

        @Override
        public void notify(IWorldObjectEvent<Item> event) {
            ItemsCache.this.notify(event.getObject());
        }
    }
}

