/*
 * Decompiled with CFR 0.152.
 */
package sk.stuba.fiit.pogamut.jungigation.worldInfo.objectsCache;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerKilled;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objectsCache.AbstractNotifiableCache;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.snapshoot.PlayerSnapshot;

public class PlayersCache
extends AbstractNotifiableCache<Player> {
    private final Map<IWorldView, PlayersListener> listeners = new HashMap<IWorldView, PlayersListener>();
    private final Map<IWorldView, PlayerKilledListener> listenersKill = new HashMap<IWorldView, PlayerKilledListener>();
    private final Map<UnrealId, List<PlayerSnapshot>> playersHistory = Collections.synchronizedMap(new HashMap());
    public static final int HISTORYSIZE = 20;

    public PlayersCache(IWorldView worldView) {
        this.addAnotherViewer(worldView);
    }

    @Override
    public void addAnotherViewer(IWorldView worldView) {
        PlayersListener tmp = new PlayersListener();
        this.listeners.put(worldView, tmp);
        worldView.addObjectListener(Player.class, tmp);
        PlayerKilledListener tmp2 = new PlayerKilledListener();
        this.listenersKill.put(worldView, tmp2);
        worldView.addEventListener(PlayerKilled.class, tmp2);
    }

    @Override
    public void removeViewer(IWorldView worldView) {
        PlayersListener tmp = this.listeners.get(worldView);
        this.listeners.remove(worldView);
        worldView.removeObjectListener(Player.class, tmp);
        PlayerKilledListener tmp2 = this.listenersKill.get(worldView);
        this.listenersKill.remove(worldView);
        worldView.removeEventListener(PlayerKilled.class, tmp2);
    }

    public List<PlayerSnapshot> getPlayerHistory(UnrealId id) {
        if (id == null) {
            throw new NullPointerException("id parameter could not be null!");
        }
        return Collections.unmodifiableList(this.playersHistory.get(id));
    }

    public Map<UnrealId, List<PlayerSnapshot>> getPlayersHistory() {
        return Collections.unmodifiableMap(this.playersHistory);
    }

    public int getNumberOfPlayers() {
        return this.playersHistory.size();
    }

    @Override
    protected void notify(Player event) {
        List<PlayerSnapshot> oneItemHistory = this.playersHistory.get(event.getId());
        if (oneItemHistory == null) {
            oneItemHistory = Collections.synchronizedList(new LinkedList());
            this.playersHistory.put(event.getId(), oneItemHistory);
        }
        oneItemHistory.add(0, new PlayerSnapshot(event));
        while (oneItemHistory.size() > 20) {
            oneItemHistory.remove(20);
        }
        super.notify(event);
    }

    protected void notifyKill(PlayerKilled event) {
        List<PlayerSnapshot> oneItemHistory = this.playersHistory.get(event.getId());
        if (oneItemHistory == null) {
            oneItemHistory = Collections.synchronizedList(new LinkedList());
            this.playersHistory.put(event.getId(), oneItemHistory);
        }
        oneItemHistory.add(0, new PlayerSnapshot(event));
        while (oneItemHistory.size() > 20) {
            oneItemHistory.remove(20);
        }
    }

    private class PlayerKilledListener
    implements IWorldEventListener<PlayerKilled> {
        private PlayerKilledListener() {
        }

        @Override
        public void notify(PlayerKilled event) {
            PlayersCache.this.notifyKill(event);
        }
    }

    private class PlayersListener
    implements IWorldObjectListener<Player> {
        private PlayersListener() {
        }

        @Override
        public void notify(IWorldObjectEvent<Player> event) {
            PlayersCache.this.notify(event.getObject());
        }
    }
}

