/*
 * Decompiled with CFR 0.152.
 */
package sk.stuba.fiit.pogamut.jungigation.worldInfo.prophets;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.FlagInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objects.SimpleFlagInfo;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objectsCache.FlagsCache;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.prophets.GamersProphet;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.snapshoot.FlagSnapshoot;

public class FlagsProphet
extends FlagsCache {
    private FlagInfo redFlag = null;
    private FlagInfo blueFlag = null;
    private FlagInfo enemyFlag = null;
    private FlagInfo myFlag = null;
    private final int team;
    private final GameInfo gameInfo;
    private final GamersProphet gamersProphet;
    private final Collection<FlagInfo> flags;
    private SimpleFlagInfo enemySimpleFlag = null;
    private SimpleFlagInfo mySimpleFlag = null;

    public FlagsProphet(IWorldView worldView, int team, GameInfo gameInfo, GamersProphet gamersProphet) {
        super(worldView);
        this.team = team;
        this.gameInfo = gameInfo;
        this.gamersProphet = gamersProphet;
        this.flags = worldView.getAll(FlagInfo.class).values();
    }

    protected FlagInfo getRedFlag() {
        if (this.redFlag == null) {
            for (FlagInfo flag : this.flags) {
                if (flag.getTeam() != 0) continue;
                this.redFlag = flag;
                break;
            }
            if (this.redFlag == null) {
                throw new RuntimeException("Red flag not found!");
            }
        }
        return this.redFlag;
    }

    protected FlagInfo getBlueFlag() {
        if (this.blueFlag == null) {
            for (FlagInfo flag : this.flags) {
                if (flag.getTeam() != 1) continue;
                this.blueFlag = flag;
                break;
            }
            if (this.blueFlag == null) {
                throw new RuntimeException("Blue flag not found!");
            }
        }
        return this.blueFlag;
    }

    protected FlagInfo getEnemyFlag() {
        if (this.enemyFlag == null) {
            switch (this.team) {
                case 0: {
                    this.enemyFlag = this.getBlueFlag();
                    break;
                }
                case 1: {
                    this.enemyFlag = this.getRedFlag();
                    break;
                }
                default: {
                    throw new RuntimeException("I am not in red nor in blue team! My team is: " + this.team);
                }
            }
        }
        return this.enemyFlag;
    }

    protected FlagInfo getMyFlag() {
        if (this.myFlag == null) {
            switch (this.team) {
                case 0: {
                    this.myFlag = this.getRedFlag();
                    break;
                }
                case 1: {
                    this.myFlag = this.getBlueFlag();
                    break;
                }
                default: {
                    throw new RuntimeException("I am not in red nor in blue team! My team is: " + this.team);
                }
            }
        }
        return this.myFlag;
    }

    public SimpleFlagInfo getEnemySimpleFlag() {
        block4: {
            HashSet<Map.Entry<Location, Double>> location;
            FlagInfo enemyF;
            block6: {
                block5: {
                    if (this.enemySimpleFlag != null) break block4;
                    enemyF = this.getEnemyFlag();
                    location = new HashSet<Map.Entry<Location, Double>>();
                    if (enemyF.getLocation() != null) break block5;
                    switch (this.team) {
                        case 0: {
                            location.add(new AbstractMap.SimpleImmutableEntry<Location, Double>(this.gameInfo.getBlueBaseLocation(), 0.9));
                            break block6;
                        }
                        case 1: {
                            location.add(new AbstractMap.SimpleImmutableEntry<Location, Double>(this.gameInfo.getRedBaseLocation(), 0.9));
                            break block6;
                        }
                        default: {
                            throw new RuntimeException("I am not in red nor in blue team! My team is: " + this.team);
                        }
                    }
                }
                location.add(new AbstractMap.SimpleImmutableEntry<Location, Double>(enemyF.getLocation(), 1.0));
            }
            this.enemySimpleFlag = new SimpleFlagInfo(enemyF.getId(), location);
        }
        return this.enemySimpleFlag;
    }

    public SimpleFlagInfo getMySimpleFlag() {
        block4: {
            HashSet<Map.Entry<Location, Double>> location;
            FlagInfo myF;
            block6: {
                block5: {
                    if (this.mySimpleFlag != null) break block4;
                    myF = this.getMyFlag();
                    location = new HashSet<Map.Entry<Location, Double>>();
                    if (myF.getLocation() != null) break block5;
                    switch (this.team) {
                        case 0: {
                            location.add(new AbstractMap.SimpleImmutableEntry<Location, Double>(this.gameInfo.getRedBaseLocation(), 0.9));
                            break block6;
                        }
                        case 1: {
                            location.add(new AbstractMap.SimpleImmutableEntry<Location, Double>(this.gameInfo.getBlueBaseLocation(), 0.9));
                            break block6;
                        }
                        default: {
                            throw new RuntimeException("I am not in red nor in blue team! My team is: " + this.team);
                        }
                    }
                }
                location.add(new AbstractMap.SimpleImmutableEntry<Location, Double>(myF.getLocation(), 1.0));
            }
            this.mySimpleFlag = new SimpleFlagInfo(myF.getId(), location);
        }
        return this.mySimpleFlag;
    }

    protected Location getHomeLocationForBlue() {
        return this.gameInfo.getBlueBaseLocation();
    }

    protected Location getHomeLocationForRed() {
        return this.gameInfo.getRedBaseLocation();
    }

    public Location getHomeLocationForEnemy() {
        switch (this.team) {
            case 0: {
                return this.getHomeLocationForBlue();
            }
            case 1: {
                return this.getHomeLocationForRed();
            }
        }
        throw new RuntimeException("I am not in red nor in blue team! My team is: " + this.team);
    }

    public Location getHomeLocationForMy() {
        switch (this.team) {
            case 0: {
                return this.getHomeLocationForRed();
            }
            case 1: {
                return this.getHomeLocationForBlue();
            }
        }
        throw new RuntimeException("I am not in red nor in blue team! My team is: " + this.team);
    }

    @Override
    protected void notify(FlagInfo event) {
        super.notify(event);
        UnrealId holderId = event.getHolder();
        List<FlagSnapshoot> history = this.getFlagHistory(event.getId());
        double lastSeen = event.getSimTime();
        Location flagHomeLocation = null;
        if (event.equals(this.getMyFlag())) {
            flagHomeLocation = this.getHomeLocationForMy();
        } else if (event.equals(this.getEnemyFlag())) {
            flagHomeLocation = this.getHomeLocationForEnemy();
        } else {
            throw new RuntimeException("Unknown flag info! That flag is not my nor enemy! Flagevent:" + event);
        }
        HashSet<Map.Entry<Location, Double>> location = new HashSet<Map.Entry<Location, Double>>();
        double probability = history.get(0).getAge() / 30.0;
        if (probability > 1.0) {
            location.add(new AbstractMap.SimpleImmutableEntry<Location, Double>(flagHomeLocation, 0.9));
        } else {
            probability = 1.0 - probability;
            Location loc = null;
            int i = 0;
            while (loc == null && i < history.size()) {
                loc = history.get(i++).getLocation();
            }
            if (loc == null) {
                location.add(new AbstractMap.SimpleImmutableEntry<Location, Double>(flagHomeLocation, 0.9));
            } else {
                location.add(new AbstractMap.SimpleImmutableEntry<Object, Double>(loc, probability));
            }
        }
        if (event.equals(this.getMyFlag())) {
            this.getMySimpleFlag().setHolder(holderId);
            this.mySimpleFlag.setLastSeenTime(lastSeen);
            this.mySimpleFlag.setFuzzyLocation(location);
        } else if (event.equals(this.getEnemyFlag())) {
            this.getEnemySimpleFlag().setHolder(holderId);
            this.enemySimpleFlag.setLastSeenTime(lastSeen);
            this.enemySimpleFlag.setFuzzyLocation(location);
        } else {
            throw new RuntimeException("Unknown flag info! That flag is not my nor enemy! Flagevent:" + event);
        }
    }
}

