/*
 * Decompiled with CFR 0.152.
 */
package sk.stuba.fiit.pogamut.jungigation.worldInfo.snapshoot;

import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.GameTime;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objectsCache.misc.LocationValhalla;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.snapshoot.Snapshoot;

public class PlayerSnapshot
extends Snapshoot {
    protected final Velocity velocity;
    protected final String weapon;
    protected final int firing;

    public PlayerSnapshot(Player player) {
        super(player.getId(), player.getLocation(), player.getSimTime());
        this.velocity = player.getVelocity();
        this.weapon = player.getWeapon();
        this.firing = player.getFiring();
    }

    public PlayerSnapshot(PlayerSnapshot playerSnapshot) {
        super(playerSnapshot);
        this.velocity = playerSnapshot.getVelocity();
        this.weapon = playerSnapshot.getWeapon();
        this.firing = playerSnapshot.getFiring();
    }

    protected PlayerSnapshot(Self self) {
        super(self.getId(), self.getLocation(), self.getSimTime());
        this.velocity = self.getVelocity();
        this.weapon = self.getWeapon();
        this.firing = self.isShooting() ? 1 : (self.isAltFiring() ? 2 : 0);
    }

    public PlayerSnapshot(PlayerKilled killEvent) {
        super(killEvent.getId(), new LocationValhalla(), GameTime.actualTime);
        this.velocity = null;
        this.weapon = null;
        this.firing = 0;
    }

    public Velocity getVelocity() {
        return this.velocity;
    }

    public String getWeapon() {
        return this.weapon;
    }

    public int getFiring() {
        return this.firing;
    }
}

