package sk.stuba.fiit.pogamut.iexplorer6;

import java.io.IOException;
import java.util.List;

import org.apache.log4j.Logger;

import sk.stuba.fiit.pogamut.jungigation.bot.AbstractBotWithJungigation;
import sk.stuba.fiit.pogamut.jungigation.objects.MyEdge;
import sk.stuba.fiit.pogamut.jungigation.objects.MyVertice;
import sk.stuba.fiit.pogamut.jungigation.objects.NavigationGraphProviderForMap;
import sk.stuba.fiit.pogamut.jungigation.pathPlanners.PathPlannerForDataAcquisition;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.GameTime;
import cz.cuni.amis.introspection.java.JProp;
import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutorState;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.agent.state.WaitForAgentStateChange;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateStopped;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004BotFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004BotModule;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.FlagListener;

/**
 * <p>
 * This class is simple agent for UT2004 which has only one purpose. Its goal is to explore whole navigation graph and
 * make graphML files. These files contains navigation graph with some informations. Most important one is time needed
 * for traveling along graph edge.
 * </p>
 * <p>
 * TODO Iexplorer6 - add some code which will try to replan path instead respawn.
 * </p>
 * 
 * @author LuVar
 */
public class Iexplorer6 extends AbstractBotWithJungigation implements FlagListener<IPathExecutorState> {
    private final Logger log = Logger.getLogger(Iexplorer6.class);

    /**
     * <p>
     * Current bot state. iexplorer6 can be {@link BotStateEnum#RESPAWNED} (after death, state set in {@link #botKilled(BotKilled)}
     * method), {@link BotStateEnum#RUNNINGTOSOMENAVPOINT} (state set in {@link #logic()} method after detected respawned, or
     * destination reached state) and {@link BotStateEnum#DESTINATIONREACHED} (state set in {@link #flagChanged(IPathExecutorState)}
     * method).
     * </p>
     */
    @JProp
    public BotStateEnum state = BotStateEnum.RESPAWNED;
    public NavPoint lastNavPoint = null;
    @JProp
    private double lastCheckpointTime = -10;

    /**
     * <p>
     * Won't respawn earlier than this time. It is threshold for catching path broken event and waiting for auto-handle that problem.
     * </p>
     */
    public static final double RESPAWNAFTERMINIMUMTIME = 10;
    private IPathPlanner<ILocated> pathPlanner;

    private int counterOfLogic = 0;
    private int someCounter = 50;
    private double lastLearningTimeSaved = Double.NaN;

    @Override
    public void logic() throws PogamutException {
	try {
	    //this.bot.getAct().act(n);
	    
	    if ((this.state.equals(BotStateEnum.DESTINATIONREACHED)) || (this.state.equals(BotStateEnum.RESPAWNED))) {
		this.lastNavPoint = null;
		this.setLastCheckpointTime(GameTime.actualTime);
		this.planRandomTarget();
		this.state = BotStateEnum.RUNNINGTOSOMENAVPOINT;
	    }

	    // Code that will in CTF mode try to change teams to balance map coverage
	    /*
	     * if (this.someCounter == 100) { this.log.info("Going to change team to blue."); this.getAct().act(new
	     * ChangeTeam(this.ai.getId(), 1)); if (this.someCounter == 200) {
	     * this.log.info("Going to change team to red."); this.getAct().act(new ChangeTeam(this.ai.getId(), 0));
	     * this.someCounter = 0; } }
	     */

	    if (++this.counterOfLogic % 40 == 0) {
		this.counterOfLogic = 0;
		this.someCounter++;
		this.saveLearningTime();
	    }
	} catch (Exception ex) {
	    throw new RuntimeException("Error in logic method! Error:" + ex.getMessage(), ex);
	}
    }// end of method logic

    private void saveLearningTime() {
	double actualTime = GameTime.actualTime; // this.ai.getTime();
	double diffTime = actualTime - this.lastLearningTimeSaved;
	if (!Double.isInfinite(diffTime) && !Double.isNaN(diffTime) && diffTime > 0 && diffTime < 40) {
	    this.navigationGraph.addLearningTime(diffTime);
	} else {
	    this.log.warn("Not adding learning time, because it is strange! It is " + diffTime);
	}
	this.lastLearningTimeSaved = actualTime;
    }

    @Override
    public void botKilled(BotKilled event) {
	this.log.info("Bot killed. Changing state to RESPAWNED.");
	this.state = BotStateEnum.RESPAWNED;
	this.navigationGraph.increaseRespawnCount();
	// this.log.info("SD.getStuckDetectedCount()=" + ((UT2004PositionHistoryStuckDetector)this.sd).getStuckDetectedCount());
	this.saveLearningTime();
	try {
	    NavigationGraphProviderForMap.getInstance().saveNavigationGraph(this.navigationGraph);
	} catch (IOException ex) {
	    this.log.warn("Error while trying save graph uppon bot death! Error: " + ex.getMessage(), ex);
	}
    }

    @Override
    public Initialize getInitializeCommand() {
	// TODO init bot's params there
	return new Initialize();
    }

    @Override
    public void botInitialized(GameInfo info, ConfigChange config, InitedMessage init) {
	super.botInitialized(info, config, init);
	// TODO handle this NavigationGraphProviderForMap.getInstance().startLearningMap(this.mapName);

	this.pathPlanner = new PathPlannerForDataAcquisition(this.navigationGraph, this.bot, this.navpoints);
	//this.pathPlanner = new PathPlannerTimeOptimized(this.navigationGraph, bot, navpoints);
	// this.pathExecutor.addPathListener(this);
	this.pathExecutor.getState().addListener(this);
	log.info("Autosaving of graph is going to start.");
	NavigationGraphProviderForMap.getInstance().startLearningMap(this.mapName);
    }

    private void planRandomTarget() {
	NavPoint target = goToRandomNavPoint();
	this.lastNavPoint = null;
	this.lastCheckpointTime = -10;
	this.state = BotStateEnum.RUNNINGTOSOMENAVPOINT;
    }

    /**
     * Picks random navpoint and goes to it.
     */
    protected NavPoint goToRandomNavPoint() {
	NavPoint navPoint = pickNewRandomNavTarget();
	// NavPoint navPoint = pickNewNavTarget();

	// find path to the random navpoint, path is computed asynchronously
	// so the handle will hold the result onlt after some time
	final IPathFuture<ILocated> pathHandle = this.pathPlanner.computePath(this.bot.getLocation(), navPoint);
	// make the path executor follow the path, executor listens for the
	// asynchronous result of path planning

	List<ILocated> path = pathHandle.get();
	this.log.debug("Planned path is going to be set to: " + pathHandle.toString());

	Thread vlakno = new Thread(new Runnable() {
	    public void run() {
		try {
		    Iexplorer6.this.log.trace("Going to \"followPath\".");
		    Iexplorer6.this.pathExecutor.followPath(pathHandle);
		    Iexplorer6.this.log.trace("\"followPath\" done.");
		} catch (Exception ex) {
		    Iexplorer6.this.log.warn("Error while trying to execute path! Error:" + ex.getMessage() + ". Error stacktrace:" + ex.getStackTrace());
		}
	    }
	});
	vlakno.setDaemon(true);
	vlakno.setName("Path executor folow path thread");
	vlakno.start();
	return navPoint;
    }

    /**
     * This method is called when the bot is started either from IDE or from command line. It connects the bot to the
     * game server.
     * 
     * @param args
     */
    public static void main(String args[]) throws PogamutException {
	UT2004BotFactory factory = new UT2004BotFactory(new UT2004BotModule(Iexplorer6.class));

	// TODO here you can rename your bot, the name of the class is used now
	UT2004BotRunner botRunner = new UT2004BotRunner(factory, "Iexplorer6", "localhost", 3000);
	//UT2004BotRunner botRunner = new UT2004BotRunner(factory, "Iexplorer6", "192.168.93.103", 3000);
	//UT2004BotRunner botRunner = new UT2004BotRunner(factory, "Iexplorer6", "195.242.237.18", 3000);
	IAgent agent = botRunner.startAgent();

	// wait until the bot finishes and close Pogamut platform
	new WaitForAgentStateChange(agent.getState(), IAgentStateStopped.class).await();
	Pogamut.getPlatform().close();
    }

    public double getLastCheckpointTime() {
	return this.lastCheckpointTime;
    }

    public void setLastCheckpointTime(double time) {
	this.lastCheckpointTime = time;
    }

    public void flagChanged(IPathExecutorState event) {
	NavPoint nearestNavPoint = DistanceUtils.getNearest(this.navpoints, this.bot.getLocation());
	switch (event.getState()) {
	case TARGET_REACHED:
	    this.log.fatal("Target reached, going to plan new random target.");
	    this.state = BotStateEnum.DESTINATIONREACHED;
	    
	    break;
	case STUCK:
	    this.log.info("Bot stucked, going to respawn if needed.");
	    this.navigationGraph.increaseStucksCount();
	    this.respawnIfNeeded();
	    break;
	case PATH_COMPUTATION_FAILED:
	    this.log.info("Path broken, going to respawn if needed.");
	    this.respawnIfNeeded();
	    break;
	case SWITCHED_TO_ANOTHER_PATH_ELEMENT:
	    this.log.trace("PATH_ELEMENT_REACHED:" + nearestNavPoint.getId().getStringId());
	    if (this.lastNavPoint != null) {
		MyVertice from = new MyVertice(this.lastNavPoint);
		MyVertice to = new MyVertice(nearestNavPoint);
		MyEdge incidentEdge;
		try {
		    incidentEdge = this.navigationGraph.findEdge(from, to);
		    double travelTime = GameTime.actualTime - this.getLastCheckpointTime();
		    this.log.debug("Adding new travel time between vertices " + from + " and " + to + ". Time was " + travelTime + ".");
		    incidentEdge.addNewTravelTime(travelTime);
		} catch (Exception ex) {
		    this.log.warn("Edge not found!");
		}
	    }// end of lastNavPoint != null
	    this.setLastCheckpointTime(GameTime.actualTime);
	    this.lastNavPoint = nearestNavPoint;
	    break;
	default:
	    this.log.warn("Unexpected event! EventType=" + event + ", eventType: " + event.getClass());
	    break;
	}
    }// end of method onEvent

    private void respawnIfNeeded() {
	if (this.lastNavPoint != null) {
	    MyVertice from = new MyVertice(this.lastNavPoint);
	    NavPoint pathExecutorNextTargerWas = null;
	    try {
		pathExecutorNextTargerWas = (NavPoint) this.pathExecutor.getPath().get(this.pathExecutor.getPathElementIndex() + 1);
	    } catch (Exception ex) {
	    }
	    if (pathExecutorNextTargerWas == null) {
		pathExecutorNextTargerWas = this.pickNewRandomNavTarget();
	    }
	    MyVertice to = new MyVertice(pathExecutorNextTargerWas);

	    MyEdge incidentEdge;
	    try {
		incidentEdge = this.navigationGraph.findEdge(from, to);
		double travelTime = 1000;
		this.log.debug("Adding MAXIMUM time between vertices " + from + " and " + to + ". Bot stucked between vertices.");
		incidentEdge.addNewTravelTime(travelTime);
	    } catch (Exception ex) {
		this.log.warn("Edge not found!");
	    }
	    this.log.info("respawning");
	} else {// end of lastNavPoint != null
	    this.log.info("respawning (lastNavpoint == null)");
	}
	// Stop path executor...
	// this.pathExecutor.followPath(new EmptyPathHandle<ILocated>());
	this.log.info("Going to respawn.");
	this.pathExecutor.stop();
	this.bot.respawn();
    }// end of method respawnIfNeeded
}
