/*
 * Decompiled with CFR 0.152.
 */
package kul.cs.liir.muse.amuse.jaxb;

import java.util.EnumSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlEnum;
import kul.cs.liir.muse.amuse.jaxb.utils.JAXBUtils;

@XmlEnum
public enum PartOfSpeech {
    COORDINATING_CONJUCTION("Coordinating conjunction"),
    CARDINAL_NUMBER("Cardinal number"),
    DETERMINER("Determiner"),
    EXISTENTIAL_THERE("Existential there"),
    FOREIGN_WORD("Foreign word"),
    IN("Preposition or subordinating conjunction"),
    ADJECTIVE("Adjective"),
    ADJECTIVE_COMPARATIVE("Adjective, comparative"),
    ADJECTIVE_SUPERLATIVE("Adjective, superlative"),
    LIST_ITEM("List item marker"),
    MODAL("Modal"),
    NOUN_SINGULAR("Noun, singular or mass"),
    NOUN_PLURAL("Noun, plural"),
    PROPER_NOUN_SINGULAR("Proper noun, singular"),
    PROPER_NOUN_PRULAL("Proper noun, plural"),
    PREDETERMINER("Predeterminer"),
    POSSESIVE_ENDING("Possessive ending"),
    PRONOUN_PERSONAL("Personal pronoun"),
    PRONOUN_POSSESIVE("Possessive pronoun"),
    ADVERB("Adverb"),
    ADVERB_COMPARATIVE("Adverb, comparative"),
    ADVERB_SUPERLATIVE("Adverb, superlative"),
    PARTICLE("Particle"),
    SYMBOL("Symbol"),
    TO("to"),
    INTERJECTION("Interjection"),
    VERB_BASE("Verb, base form"),
    VERB_PAST_TENSE("Verb, past tense"),
    VERB_GERUND("Verb, gerund or present participle"),
    VERB_PAST_PARTICIPLE("Verb, past participle"),
    VERB_PRESENT_NON_3RD("Verb, non-3rd person singular present"),
    VERB_PRESENT_3RD("Verb,  3rd person singular present"),
    WH_DETERMINER("Wh-determiner"),
    WH_PRONOUN("Wh-pronoun"),
    WH_PRONOUN_POSSESIVE("Possessive wh-pronoun"),
    WH_ADVERB("Wh-adverb"),
    DOT("."),
    DOUBLE_SINGLE_QUOTE("''"),
    COMMA(","),
    SEMICOLON(";"),
    DOUBLE_APOSTROPH_QUOTE("``"),
    HYPHEN("-");

    private String userFriendlyName;
    private static Set<PartOfSpeech> nouns;
    private static Set<PartOfSpeech> verbs;

    static {
        nouns = EnumSet.of(NOUN_SINGULAR, NOUN_PLURAL, PROPER_NOUN_SINGULAR, PROPER_NOUN_PRULAL);
        verbs = EnumSet.of(VERB_BASE, new PartOfSpeech[]{VERB_GERUND, VERB_PAST_PARTICIPLE, VERB_PAST_TENSE, VERB_PRESENT_3RD, VERB_PRESENT_NON_3RD});
    }

    private PartOfSpeech(String userFriendlyName) {
        this.userFriendlyName = userFriendlyName;
    }

    public String getUserFriendlyName() {
        return this.userFriendlyName;
    }

    public static PartOfSpeech byXMLValue(String xmlValue) {
        return JAXBUtils.enumValueByXmlValue(PartOfSpeech.class, xmlValue);
    }

    public static boolean isNoun(PartOfSpeech p) {
        return nouns.contains((Object)p);
    }

    public static boolean isVerb(PartOfSpeech p) {
        return verbs.contains((Object)p);
    }
}

