/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.harmony.runtime.java.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.sourceforge.retroweaver.harmony.runtime.internal.nls.Messages;
import net.sourceforge.retroweaver.harmony.runtime.java.math.Multiplication;
import net.sourceforge.retroweaver.harmony.runtime.java.math.RoundingMode;
import net.sourceforge.retroweaver.runtime.java.lang.Math_;

public class BigDecimal_ {
    public static final BigDecimal ZERO = BigDecimal.valueOf(0L);
    public static final BigDecimal ONE = BigDecimal.valueOf(1L);
    public static final BigDecimal TEN = BigDecimal.valueOf(10L);
    private static final double LOG10_2 = 0.3010299956639812;
    private static final BigInteger[] FIVE_POW;
    private static final BigInteger[] TEN_POW;

    private BigDecimal_() {
    }

    public static BigDecimal BigDecimal(char[] in, int offset, int len) {
        return new BigDecimal(new String(in, offset, len));
    }

    public static BigDecimal BigDecimal(char[] in) {
        return new BigDecimal(new String(in, 0, in.length));
    }

    public static BigDecimal BigDecimal(int val) {
        double d = val;
        return new BigDecimal(d);
    }

    public static BigDecimal BigDecimal(long val) {
        String s = Long.toString(val);
        return new BigDecimal(s);
    }

    public static BigDecimal valueOf(double val) {
        if (Double.isInfinite(val) || Double.isNaN(val)) {
            throw new NumberFormatException(Messages.getString("math.03"));
        }
        return new BigDecimal(Double.toString(val));
    }

    public static BigDecimal divide(BigDecimal o, BigDecimal divisor, int scale, RoundingMode roundingMode) {
        return o.divide(divisor, scale, roundingMode.ordinal());
    }

    public static BigDecimal divide(BigDecimal o, BigDecimal divisor, RoundingMode roundingMode) {
        return o.divide(divisor, roundingMode.ordinal());
    }

    public static BigDecimal divide(BigDecimal o, BigDecimal divisor) {
        BigInteger p = o.unscaledValue();
        BigInteger q = divisor.unscaledValue();
        long diffScale = (long)o.scale() - (long)divisor.scale();
        int l = 0;
        int i = 1;
        int lastPow = FIVE_POW.length - 1;
        if (BigDecimal_.isZero(divisor)) {
            throw new ArithmeticException(Messages.getString("math.04"));
        }
        if (p.signum() == 0) {
            return BigDecimal_.zeroScaledBy(diffScale);
        }
        BigInteger gcd = p.gcd(q);
        p = p.divide(gcd);
        q = q.divide(gcd);
        int k = q.getLowestSetBit();
        q = q.shiftRight(k);
        while (true) {
            BigInteger[] quotAndRem;
            if ((quotAndRem = q.divideAndRemainder(FIVE_POW[i]))[1].signum() == 0) {
                l += i;
                if (i < lastPow) {
                    ++i;
                }
                q = quotAndRem[0];
                continue;
            }
            if (i == 1) break;
            i = 1;
        }
        if (!q.abs().equals(BigInteger.ONE)) {
            throw new ArithmeticException(Messages.getString("math.05"));
        }
        if (q.signum() < 0) {
            p = p.negate();
        }
        int newScale = BigDecimal_.toIntScale(diffScale + (long)Math.max(k, l));
        i = k - l;
        p = i > 0 ? Multiplication.multiplyByFivePow(p, i) : p.shiftLeft(-i);
        return new BigDecimal(p, newScale);
    }

    public static BigDecimal divideToIntegralValue(BigDecimal o, BigDecimal divisor) {
        BigInteger integralValue;
        BigInteger[] quotAndRem = new BigInteger[]{o.unscaledValue()};
        long newScale = (long)o.scale() - (long)divisor.scale();
        long tempScale = 0L;
        int i = 1;
        int lastPow = TEN_POW.length - 1;
        if (BigDecimal_.isZero(divisor)) {
            throw new ArithmeticException(Messages.getString("math.04"));
        }
        if ((long)BigDecimal_.aproxPrecision(divisor) + newScale > (long)BigDecimal_.aproxPrecision(o) + 1L || BigDecimal_.isZero(o)) {
            integralValue = BigInteger.ZERO;
        } else if (newScale == 0L) {
            integralValue = o.unscaledValue().divide(divisor.unscaledValue());
        } else if (newScale > 0L) {
            BigInteger powerOfTen = Multiplication.powerOf10(newScale);
            integralValue = o.unscaledValue().divide(divisor.unscaledValue().multiply(powerOfTen));
            integralValue = integralValue.multiply(powerOfTen);
        } else {
            BigInteger powerOfTen = Multiplication.powerOf10(-newScale);
            integralValue = o.unscaledValue().multiply(powerOfTen).divide(divisor.unscaledValue());
            while (!integralValue.testBit(0)) {
                quotAndRem = integralValue.divideAndRemainder(TEN_POW[i]);
                if (quotAndRem[1].signum() == 0 && tempScale - (long)i >= newScale) {
                    tempScale -= (long)i;
                    if (i < lastPow) {
                        ++i;
                    }
                    integralValue = quotAndRem[0];
                    continue;
                }
                if (i == 1) break;
                i = 1;
            }
            newScale = tempScale;
        }
        return integralValue.signum() == 0 ? BigDecimal_.zeroScaledBy(newScale) : new BigDecimal(integralValue, BigDecimal_.toIntScale(newScale));
    }

    public static BigDecimal[] divideAndRemainder(BigDecimal o, BigDecimal divisor) {
        BigDecimal[] quotAndRem;
        quotAndRem = new BigDecimal[]{BigDecimal_.divideToIntegralValue(o, divisor), o.subtract(quotAndRem[0].multiply(divisor))};
        return quotAndRem;
    }

    private static boolean isZero(BigDecimal o) {
        return o.signum() == 0;
    }

    public static int precision(BigDecimal o) {
        int bitLength = o.unscaledValue().bitLength();
        int decimalDigits = 1;
        double doubleUnsc = 1.0;
        if (bitLength < 1024) {
            if (bitLength >= 64) {
                doubleUnsc = o.unscaledValue().doubleValue();
            } else if (bitLength >= 1) {
                doubleUnsc = o.unscaledValue().longValue();
            }
            decimalDigits = (int)((double)decimalDigits + Math_.log10(Math.abs(doubleUnsc)));
        } else {
            decimalDigits = (int)((double)decimalDigits + (double)(bitLength - 1) * 0.3010299956639812);
            if (o.unscaledValue().divide(Multiplication.powerOf10(decimalDigits)).signum() != 0) {
                ++decimalDigits;
            }
        }
        int precision = decimalDigits;
        return precision;
    }

    public static BigDecimal setScale(BigDecimal o, int newScale, RoundingMode roundingMode) {
        return o.setScale(newScale, roundingMode.ordinal());
    }

    public static BigDecimal stripTrailingZeros(BigDecimal o) {
        int i = 1;
        int lastPow = TEN_POW.length - 1;
        long newScale = o.scale();
        if (BigDecimal_.isZero(o)) {
            return new BigDecimal("0");
        }
        BigInteger strippedBI = o.unscaledValue();
        while (!strippedBI.testBit(0)) {
            BigInteger[] quotAndRem = strippedBI.divideAndRemainder(TEN_POW[i]);
            if (quotAndRem[1].signum() == 0) {
                newScale -= (long)i;
                if (i < lastPow) {
                    ++i;
                }
                strippedBI = quotAndRem[0];
                continue;
            }
            if (i == 1) break;
            i = 1;
        }
        return new BigDecimal(strippedBI, BigDecimal_.toIntScale(newScale));
    }

    private static int aproxPrecision(BigDecimal o) {
        return BigDecimal_.precision(o);
    }

    private static int toIntScale(long longScale) {
        if (longScale < Integer.MIN_VALUE) {
            throw new ArithmeticException(Messages.getString("math.09"));
        }
        if (longScale > Integer.MAX_VALUE) {
            throw new ArithmeticException(Messages.getString("math.0A"));
        }
        return (int)longScale;
    }

    private static BigDecimal zeroScaledBy(long longScale) {
        if (longScale == (long)((int)longScale)) {
            return BigDecimal.valueOf(0L, (int)longScale);
        }
        if (longScale >= 0L) {
            return new BigDecimal(BigInteger.ZERO, Integer.MAX_VALUE);
        }
        return new BigDecimal(BigInteger.ZERO, Integer.MIN_VALUE);
    }

    static {
        TEN_POW = Multiplication.bigTenPows;
        FIVE_POW = Multiplication.bigFivePows;
    }
}

