/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tools.project.extras;

import java.io.File;
import java.util.Set;
import org.codehaus.plexus.util.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScanningUtils {
    private ScanningUtils() {
    }

    public static long getLatestLastMod(File directory, Set<String> includes, Set<String> excludes) {
        DirectoryScanner scanner = new DirectoryScanner();
        if (includes != null && !includes.isEmpty()) {
            String[] incl = includes.toArray(new String[includes.size()]);
            scanner.setIncludes(incl);
        }
        if (excludes != null && !excludes.isEmpty()) {
            String[] excl = excludes.toArray(new String[excludes.size()]);
            scanner.setExcludes(excl);
        }
        scanner.setBasedir(directory);
        scanner.scan();
        String[] results = scanner.getIncludedFiles();
        long lastMod = 0L;
        for (int i = 0; i < results.length; ++i) {
            String filename = results[i];
            File file = new File(directory, filename);
            long lm = file.lastModified();
            if (lm <= lastMod) continue;
            lastMod = lm;
        }
        return lastMod;
    }
}

