/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.cvsclient.request.GlobalOptionRequest;
import org.netbeans.lib.cvsclient.request.Request;
import org.netbeans.lib.cvsclient.request.SetRequest;

public class GlobalOptions
implements Cloneable {
    private List variables = new ArrayList();
    private boolean doNoChanges;
    private boolean checkedOutFilesReadOnly;
    private String cvsRoot;
    private boolean useGzip = true;
    private int compressionLevel = 0;
    private boolean noHistoryLogging;
    private boolean moderatelyQuiet;
    private boolean veryQuiet;
    private boolean traceExecution;
    private boolean showHelp;
    private boolean showVersion;
    private boolean ignoreCvsrc;
    private File tempDir;
    private String editor;
    private File[] exclusions;

    public void setExclusions(File[] fileArray) {
        this.exclusions = fileArray;
    }

    public File[] getExclusions() {
        return this.exclusions;
    }

    public boolean isExcluded(File file) {
        if (this.exclusions != null) {
            for (int i = 0; i < this.exclusions.length; ++i) {
                if (!GlobalOptions.isParentOrEqual(this.exclusions[i], file)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isParentOrEqual(File file, File file2) {
        while (file2 != null) {
            if (file2.equals(file)) {
                return true;
            }
            file2 = file2.getParentFile();
        }
        return false;
    }

    public List createRequestList() {
        LinkedList<Request> linkedList = new LinkedList<Request>();
        if (this.variables.size() > 0) {
            Iterator iterator = this.variables.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                linkedList.add(new SetRequest(string));
            }
        }
        if (this.isNoHistoryLogging()) {
            linkedList.add(new GlobalOptionRequest("-l"));
        }
        if (this.isDoNoChanges()) {
            linkedList.add(new GlobalOptionRequest("-n"));
        }
        if (this.isModeratelyQuiet()) {
            linkedList.add(new GlobalOptionRequest("-q"));
        }
        if (this.isVeryQuiet()) {
            linkedList.add(new GlobalOptionRequest("-Q"));
        }
        if (this.isTraceExecution()) {
            linkedList.add(new GlobalOptionRequest("-t"));
        }
        return linkedList;
    }

    public String getOptString() {
        return "Hvnfd:lqQtrws:z:T:e:";
    }

    public boolean setCVSCommand(char c, String string) {
        if (c == 'n') {
            this.setDoNoChanges(true);
        } else if (c == 'd') {
            this.setCVSRoot(string);
        } else if (c == 'l') {
            this.setNoHistoryLogging(true);
        } else if (c == 'q') {
            this.setModeratelyQuiet(true);
        } else if (c == 'Q') {
            this.setVeryQuiet(true);
        } else if (c == 't') {
            this.setTraceExecution(true);
        } else if (c == 't') {
            this.setTraceExecution(true);
        } else if (c == 'r') {
            this.setCheckedOutFilesReadOnly(true);
        } else if (c == 'w') {
            this.setCheckedOutFilesReadOnly(false);
        } else if (c == 's') {
            this.setCvsVariable(string);
        } else if (c == 'z') {
            try {
                this.setCompressionLevel(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (c == 'H') {
            this.setShowHelp(true);
        } else if (c == 'v') {
            this.setShowVersion(true);
        } else if (c == 'f') {
            this.setIgnoreCvsrc(true);
        } else if (c == 'T') {
            this.setTempDir(new File(string));
        } else if (c == 'e') {
            this.setEditor(string);
        } else {
            return false;
        }
        return true;
    }

    public void resetCVSCommand() {
        this.setCheckedOutFilesReadOnly(false);
        this.setDoNoChanges(false);
        this.setModeratelyQuiet(false);
        this.setNoHistoryLogging(false);
        this.setTraceExecution(false);
        this.setUseGzip(true);
        this.setCompressionLevel(0);
        this.setVeryQuiet(false);
        this.setShowHelp(false);
        this.setShowVersion(false);
        this.setIgnoreCvsrc(false);
        this.setTempDir(null);
        this.setEditor(null);
        this.setCVSRoot("");
        this.clearCvsVariables();
    }

    public String getCVSCommand() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isDoNoChanges()) {
            stringBuffer.append("-n ");
        }
        if (this.isNoHistoryLogging()) {
            stringBuffer.append("-l ");
        }
        if (this.isModeratelyQuiet()) {
            stringBuffer.append("-q ");
        }
        if (this.isVeryQuiet()) {
            stringBuffer.append("-Q ");
        }
        if (this.isTraceExecution()) {
            stringBuffer.append("-t ");
        }
        if (this.isCheckedOutFilesReadOnly()) {
            stringBuffer.append("-r ");
        }
        if (this.variables.size() > 0) {
            Iterator iterator = this.variables.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                stringBuffer.append("-s " + string + " ");
            }
        }
        if (this.compressionLevel != 0) {
            stringBuffer.append("-z ");
            stringBuffer.append(Integer.toString(this.compressionLevel));
            stringBuffer.append(" ");
        }
        if (this.isIgnoreCvsrc()) {
            stringBuffer.append("-f ");
        }
        if (this.tempDir != null) {
            stringBuffer.append("-T ");
            stringBuffer.append(this.tempDir.getAbsolutePath());
            stringBuffer.append(" ");
        }
        if (this.editor != null) {
            stringBuffer.append("-e ");
            stringBuffer.append(this.editor);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public void setCvsVariable(String string) {
        this.variables.add(string);
    }

    public void clearCvsVariables() {
        this.variables.clear();
    }

    public void setCvsVariables(String[] stringArray) {
        this.clearCvsVariables();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.variables.add(string);
        }
    }

    public String[] getCvsVariables() {
        String[] stringArray = new String[this.variables.size()];
        stringArray = this.variables.toArray(stringArray);
        return stringArray;
    }

    public void setDoNoChanges(boolean bl) {
        this.doNoChanges = bl;
    }

    public boolean isDoNoChanges() {
        return this.doNoChanges;
    }

    public boolean isCheckedOutFilesReadOnly() {
        return this.checkedOutFilesReadOnly;
    }

    public void setCheckedOutFilesReadOnly(boolean bl) {
        this.checkedOutFilesReadOnly = bl;
    }

    public String getCVSRoot() {
        return this.cvsRoot;
    }

    public void setCVSRoot(String string) {
        this.cvsRoot = string;
    }

    public void setUseGzip(boolean bl) {
        this.useGzip = bl;
    }

    public boolean isUseGzip() {
        return this.useGzip;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int n) {
        this.compressionLevel = n;
    }

    public boolean isNoHistoryLogging() {
        return this.noHistoryLogging;
    }

    public void setNoHistoryLogging(boolean bl) {
        this.noHistoryLogging = bl;
    }

    public boolean isModeratelyQuiet() {
        return this.moderatelyQuiet;
    }

    public void setModeratelyQuiet(boolean bl) {
        this.moderatelyQuiet = bl;
    }

    public boolean isVeryQuiet() {
        return this.veryQuiet;
    }

    public void setVeryQuiet(boolean bl) {
        this.veryQuiet = bl;
    }

    public boolean isTraceExecution() {
        return this.traceExecution;
    }

    public void setTraceExecution(boolean bl) {
        this.traceExecution = bl;
    }

    public boolean isShowHelp() {
        return this.showHelp;
    }

    public void setShowHelp(boolean bl) {
        this.showHelp = bl;
    }

    public boolean isShowVersion() {
        return this.showVersion;
    }

    public void setShowVersion(boolean bl) {
        this.showVersion = bl;
    }

    public boolean isIgnoreCvsrc() {
        return this.ignoreCvsrc;
    }

    public void setIgnoreCvsrc(boolean bl) {
        this.ignoreCvsrc = bl;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(File file) {
        this.tempDir = file;
    }

    public String getEditor() {
        return this.editor;
    }

    public void setEditor(String string) {
        this.editor = string;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

