/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.importcmd;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BuildableCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.lib.cvsclient.command.importcmd.ImportBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.ArgumentxRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.DirectoryRequest;
import org.netbeans.lib.cvsclient.request.ModifiedRequest;
import org.netbeans.lib.cvsclient.request.Request;
import org.netbeans.lib.cvsclient.response.WrapperSendResponse;
import org.netbeans.lib.cvsclient.util.SimpleStringPattern;
import org.netbeans.lib.cvsclient.util.StringPattern;

public class ImportCommand
extends BuildableCommand {
    private Map wrapperMap = new HashMap();
    private String logMessage;
    private String module;
    private String releaseTag;
    private String vendorBranch;
    private String vendorTag;
    private String importDirectory;
    private KeywordSubstitutionOptions keywordSubstitutionOptions;
    private boolean useFileModifTime;
    private List ignoreList = new LinkedList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public ImportCommand() {
        this.resetCVSCommand();
    }

    public void addWrapper(String string, KeywordSubstitutionOptions keywordSubstitutionOptions) {
        if (keywordSubstitutionOptions == null) {
            throw new IllegalArgumentException("keywordSubstitutionOptions must not be null");
        }
        this.wrapperMap.put(new SimpleStringPattern(string), keywordSubstitutionOptions);
    }

    public void addWrapper(StringPattern stringPattern, KeywordSubstitutionOptions keywordSubstitutionOptions) {
        if (keywordSubstitutionOptions == null) {
            throw new IllegalArgumentException("keywordSubstitutionOptions must not be null");
        }
        this.wrapperMap.put(stringPattern, keywordSubstitutionOptions);
    }

    public void setWrappers(Map map) {
        this.wrapperMap = map;
    }

    public Map getWrappers() {
        return this.wrapperMap;
    }

    public KeywordSubstitutionOptions getKeywordSubstitutionOptions() {
        return this.keywordSubstitutionOptions;
    }

    public void setKeywordSubstitutionOptions(KeywordSubstitutionOptions keywordSubstitutionOptions) {
        this.keywordSubstitutionOptions = keywordSubstitutionOptions;
    }

    public String getReleaseTag() {
        return this.releaseTag;
    }

    public void setReleaseTag(String string) {
        this.releaseTag = ImportCommand.getTrimmedString(string);
    }

    public String getLogMessage() {
        return this.logMessage;
    }

    public void setLogMessage(String string) {
        this.logMessage = ImportCommand.getTrimmedString(string);
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String string) {
        this.module = ImportCommand.getTrimmedString(string);
    }

    public void setImportDirectory(String string) {
        this.importDirectory = string;
    }

    public String getImportDirectory() {
        return this.importDirectory;
    }

    public String getVendorBranch() {
        return this.vendorBranch;
    }

    private String getVendorBranchNotNull() {
        if (this.vendorBranch == null) {
            return "1.1.1";
        }
        return this.vendorBranch;
    }

    public void setVendorBranch(String string) {
        this.vendorBranch = ImportCommand.getTrimmedString(string);
    }

    public String getVendorTag() {
        return this.vendorTag;
    }

    public void setVendorTag(String string) {
        this.vendorTag = ImportCommand.getTrimmedString(string);
    }

    public boolean isUseFileModifTime() {
        return this.useFileModifTime;
    }

    public void setUseFileModifTime(boolean bl) {
        this.useFileModifTime = bl;
    }

    public List getIgnoreFiles() {
        return Collections.unmodifiableList(this.ignoreList);
    }

    public void addIgnoredFile(String string) {
        this.ignoreList.add(string);
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException, AuthenticationException {
        if (this.getLogMessage() == null) {
            String string = CommandException.getLocalMessage("ImportCommand.messageEmpty");
            throw new CommandException("message may not be null nor empty", string);
        }
        if (this.getModule() == null) {
            String string = CommandException.getLocalMessage("ImportCommand.moduleEmpty");
            throw new CommandException("module may not be null nor empty", string);
        }
        if (this.getReleaseTag() == null) {
            String string = CommandException.getLocalMessage("ImportCommand.releaseTagEmpty");
            throw new CommandException("release tag may not be null nor empty", string);
        }
        if (this.getVendorTag() == null) {
            String string = CommandException.getLocalMessage("ImportCommand.vendorTagEmpty");
            throw new CommandException("vendor tag may not be null nor empty", string);
        }
        clientServices.ensureConnection();
        HashMap hashMap = new HashMap(clientServices.getWrappersMap());
        hashMap.putAll(this.getWrappers());
        this.setWrappers(hashMap);
        super.execute(clientServices, eventManager);
        if (!$assertionsDisabled && this.getLocalDirectory() == null) {
            throw new AssertionError((Object)"local directory may not be null");
        }
        ArrayList<Request> arrayList = new ArrayList<Request>();
        try {
            arrayList.add(new ArgumentRequest("-b"));
            arrayList.add(new ArgumentRequest(this.getVendorBranchNotNull()));
            if (this.getKeywordSubstitutionOptions() != null) {
                arrayList.add(new ArgumentRequest("-k"));
                arrayList.add(new ArgumentRequest(this.getKeywordSubstitutionOptions().toString()));
            }
            this.addMessageRequests(arrayList, this.getLogMessage());
            this.addWrapperRequests(arrayList, this.wrapperMap);
            if (this.isUseFileModifTime()) {
                arrayList.add(new ArgumentRequest("-d"));
            }
            for (int i = 0; i < this.ignoreList.size(); ++i) {
                arrayList.add(new ArgumentRequest("-I"));
                arrayList.add(new ArgumentRequest((String)this.ignoreList.get(i)));
            }
            arrayList.add(new ArgumentRequest(this.getModule()));
            arrayList.add(new ArgumentRequest(this.getVendorTag()));
            arrayList.add(new ArgumentRequest(this.getReleaseTag()));
            this.addFileRequests(new File(this.getLocalDirectory()), arrayList, clientServices);
            arrayList.add(new DirectoryRequest(".", this.getRepositoryRoot(clientServices)));
            arrayList.add(CommandRequest.IMPORT);
            clientServices.processRequests(arrayList);
        }
        catch (CommandException commandException) {
            throw commandException;
        }
        catch (EOFException eOFException) {
            String string = CommandException.getLocalMessage("CommandException.EndOfFile", null);
            throw new CommandException(eOFException, string);
        }
        catch (Exception exception) {
            throw new CommandException(exception, exception.getLocalizedMessage());
        }
    }

    public String getCVSCommand() {
        String string;
        StringBuffer stringBuffer = new StringBuffer("import ");
        stringBuffer.append(this.getCVSArguments());
        if (this.getModule() != null) {
            stringBuffer.append(" ");
            stringBuffer.append(this.getModule());
        } else {
            string = CommandException.getLocalMessage("ImportCommand.moduleEmpty.text");
            stringBuffer.append(" ");
            stringBuffer.append(string);
        }
        if (this.getVendorTag() != null) {
            stringBuffer.append(" ");
            stringBuffer.append(this.getVendorTag());
        } else {
            string = CommandException.getLocalMessage("ImportCommand.vendorTagEmpty.text");
            stringBuffer.append(" ");
            stringBuffer.append(string);
        }
        if (this.getReleaseTag() != null) {
            stringBuffer.append(" ");
            stringBuffer.append(this.getReleaseTag());
        } else {
            string = CommandException.getLocalMessage("ImportCommand.releaseTagEmpty.text");
            stringBuffer.append(" ");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String getCVSArguments() {
        Iterator<Object> iterator;
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.getLogMessage() != null) {
            stringBuffer.append("-m \"");
            stringBuffer.append(this.getLogMessage());
            stringBuffer.append("\" ");
        }
        if (this.getKeywordSubstitutionOptions() != null) {
            stringBuffer.append("-k");
            stringBuffer.append(this.getKeywordSubstitutionOptions().toString());
            stringBuffer.append(" ");
        }
        if (this.getVendorBranch() != null) {
            stringBuffer.append("-b ");
            stringBuffer.append(this.getVendorBranch());
            stringBuffer.append(" ");
        }
        if (this.isUseFileModifTime()) {
            stringBuffer.append("-d ");
        }
        if (this.wrapperMap.size() > 0) {
            iterator = this.wrapperMap.keySet().iterator();
            while (iterator.hasNext()) {
                StringPattern stringPattern = (StringPattern)iterator.next();
                KeywordSubstitutionOptions keywordSubstitutionOptions = (KeywordSubstitutionOptions)this.wrapperMap.get(stringPattern);
                stringBuffer.append("-W ");
                stringBuffer.append(stringPattern.toString());
                stringBuffer.append(" -k '");
                stringBuffer.append(keywordSubstitutionOptions.toString());
                stringBuffer.append("' ");
            }
        }
        iterator = this.ignoreList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("-I ");
            stringBuffer.append((String)iterator.next());
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public boolean setCVSCommand(char c, String string) {
        if (c == 'b') {
            this.setVendorBranch(string);
        } else if (c == 'm') {
            this.setLogMessage(string);
        } else if (c == 'k') {
            this.setKeywordSubstitutionOptions(KeywordSubstitutionOptions.findKeywordSubstOption(string));
        } else if (c == 'W') {
            Map map = WrapperSendResponse.parseWrappers(string);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                StringPattern stringPattern = (StringPattern)iterator.next();
                KeywordSubstitutionOptions keywordSubstitutionOptions = (KeywordSubstitutionOptions)map.get(stringPattern);
                this.addWrapper(stringPattern, keywordSubstitutionOptions);
            }
        } else if (c == 'd') {
            this.setUseFileModifTime(true);
        } else if (c == 'I') {
            this.addIgnoredFile(string);
        } else {
            return false;
        }
        return true;
    }

    public void resetCVSCommand() {
        this.setLogMessage(null);
        this.setModule(null);
        this.setReleaseTag(null);
        this.setVendorTag(null);
        this.setVendorBranch(null);
        this.setUseFileModifTime(false);
        this.ignoreList.clear();
        this.wrapperMap.clear();
    }

    public String getOptString() {
        return "m:W:b:k:dI:";
    }

    private void addMessageRequests(List list, String string) {
        list.add(new ArgumentRequest("-m"));
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", false);
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            if (bl) {
                list.add(new ArgumentRequest(stringTokenizer.nextToken()));
                bl = false;
                continue;
            }
            list.add(new ArgumentxRequest(stringTokenizer.nextToken()));
        }
    }

    private void addWrapperRequests(List list, Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            StringPattern stringPattern = (StringPattern)iterator.next();
            KeywordSubstitutionOptions keywordSubstitutionOptions = (KeywordSubstitutionOptions)map.get(stringPattern);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(stringPattern.toString());
            stringBuffer.append(" -k '");
            stringBuffer.append(keywordSubstitutionOptions.toString());
            stringBuffer.append("'");
            list.add(new ArgumentRequest("-W"));
            list.add(new ArgumentRequest(stringBuffer.toString()));
        }
    }

    private void addFileRequests(File file, List list, ClientServices clientServices) throws IOException {
        File file2;
        String string = this.getRelativeToLocalPathInUnixStyle(file);
        String string2 = this.getRepositoryRoot(clientServices);
        if (!string.equals(".")) {
            string2 = string2 + '/' + string;
        }
        list.add(new DirectoryRequest(string, string2));
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        LinkedList<File> linkedList = null;
        for (int i = 0; i < fileArray.length; ++i) {
            file2 = fileArray[i];
            String string3 = file2.getName();
            if (clientServices.shouldBeIgnored(file, string3)) continue;
            if (file2.isDirectory()) {
                if (linkedList == null) {
                    linkedList = new LinkedList<File>();
                }
                linkedList.add(file2);
                continue;
            }
            boolean bl = this.isBinary(string3);
            list.add(new ModifiedRequest(file2, bl));
        }
        if (linkedList != null) {
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                file2 = (File)iterator.next();
                this.addFileRequests(file2, list, clientServices);
            }
        }
    }

    private String getRepositoryRoot(ClientServices clientServices) {
        String string = clientServices.getRepository() + '/' + this.getModule();
        return string;
    }

    private boolean isBinary(String string) {
        KeywordSubstitutionOptions keywordSubstitutionOptions = this.getKeywordSubstitutionOptions();
        Iterator iterator = this.wrapperMap.keySet().iterator();
        while (iterator.hasNext()) {
            StringPattern stringPattern = (StringPattern)iterator.next();
            if (!stringPattern.doesMatch(string)) continue;
            keywordSubstitutionOptions = (KeywordSubstitutionOptions)this.wrapperMap.get(stringPattern);
            break;
        }
        return keywordSubstitutionOptions == KeywordSubstitutionOptions.BINARY;
    }

    public Builder createBuilder(EventManager eventManager) {
        return new ImportBuilder(eventManager, this);
    }

    static {
        $assertionsDisabled = !ImportCommand.class.desiredAssertionStatus();
    }
}

