/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Date;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.file.DefaultTransmitTextFilePreprocessor;
import org.netbeans.lib.cvsclient.file.DefaultWriteTextFilePreprocessor;
import org.netbeans.lib.cvsclient.file.FileHandler;
import org.netbeans.lib.cvsclient.file.FileUtils;
import org.netbeans.lib.cvsclient.file.OutputStreamProvider;
import org.netbeans.lib.cvsclient.file.TransmitTextFilePreprocessor;
import org.netbeans.lib.cvsclient.file.WriteRcsDiffFilePreprocessor;
import org.netbeans.lib.cvsclient.file.WriteTextFilePreprocessor;
import org.netbeans.lib.cvsclient.request.Request;
import org.netbeans.lib.cvsclient.util.BugLog;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;
import org.netbeans.lib.cvsclient.util.LoggedDataOutputStream;

public class DefaultFileHandler
implements FileHandler {
    private static final boolean DEBUG = false;
    private static final int CHUNK_SIZE = 32768;
    private Date modifiedDate;
    private TransmitTextFilePreprocessor transmitTextFilePreprocessor;
    private WriteTextFilePreprocessor writeTextFilePreprocessor;
    private WriteTextFilePreprocessor writeRcsDiffFilePreprocessor;
    private GlobalOptions globalOptions;

    public DefaultFileHandler() {
        this.setTransmitTextFilePreprocessor(new DefaultTransmitTextFilePreprocessor());
        this.setWriteTextFilePreprocessor(new DefaultWriteTextFilePreprocessor());
        this.setWriteRcsDiffFilePreprocessor(new WriteRcsDiffFilePreprocessor());
    }

    public TransmitTextFilePreprocessor getTransmitTextFilePreprocessor() {
        return this.transmitTextFilePreprocessor;
    }

    public void setTransmitTextFilePreprocessor(TransmitTextFilePreprocessor transmitTextFilePreprocessor) {
        this.transmitTextFilePreprocessor = transmitTextFilePreprocessor;
    }

    public WriteTextFilePreprocessor getWriteTextFilePreprocessor() {
        return this.writeTextFilePreprocessor;
    }

    public void setWriteTextFilePreprocessor(WriteTextFilePreprocessor writeTextFilePreprocessor) {
        this.writeTextFilePreprocessor = writeTextFilePreprocessor;
    }

    public WriteTextFilePreprocessor getWriteRcsDiffFilePreprocessor() {
        return this.writeRcsDiffFilePreprocessor;
    }

    public void setWriteRcsDiffFilePreprocessor(WriteTextFilePreprocessor writeTextFilePreprocessor) {
        this.writeRcsDiffFilePreprocessor = writeTextFilePreprocessor;
    }

    protected String getLengthString(long l) {
        return String.valueOf(l) + "\n";
    }

    protected Reader getProcessedReader(File file) throws IOException {
        return new FileReader(file);
    }

    protected InputStream getProcessedInputStream(File file) throws IOException {
        return new FileInputStream(file);
    }

    public Request[] getInitialisationRequests() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transmitTextFile(File file, LoggedDataOutputStream loggedDataOutputStream) throws IOException {
        TransmitTextFilePreprocessor transmitTextFilePreprocessor;
        File file2;
        block12: {
            if (file == null || !file.exists()) {
                throw new IllegalArgumentException("File is either null or does not exist. Cannot transmit.");
            }
            file2 = file;
            transmitTextFilePreprocessor = this.getTransmitTextFilePreprocessor();
            if (transmitTextFilePreprocessor != null) {
                file2 = transmitTextFilePreprocessor.getPreprocessedTextFile(file);
            }
            BufferedInputStream bufferedInputStream = null;
            try {
                int n;
                long l;
                loggedDataOutputStream.writeBytes(this.getLengthString(l), "US-ASCII");
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
                byte[] byArray = new byte[32768];
                for (l = file2.length(); l > 0L; l -= (long)n) {
                    int n2 = l >= 32768L ? 32768 : (int)l;
                    n = bufferedInputStream.read(byArray, 0, n2);
                    if (n == -1) {
                        throw new IOException("Unexpected end of stream from " + file2 + ".");
                    }
                    loggedDataOutputStream.write(byArray, 0, n);
                }
                loggedDataOutputStream.flush();
                Object var12_10 = null;
                if (bufferedInputStream == null) break block12;
            }
            catch (Throwable throwable) {
                Object var12_11 = null;
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (transmitTextFilePreprocessor != null) {
                    transmitTextFilePreprocessor.cleanup(file2);
                }
                throw throwable;
            }
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (transmitTextFilePreprocessor != null) {
            transmitTextFilePreprocessor.cleanup(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void transmitBinaryFile(File file, LoggedDataOutputStream loggedDataOutputStream) throws IOException {
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException("File is either null or does not exist. Cannot transmit.");
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            int n;
            long l;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            loggedDataOutputStream.writeBytes(this.getLengthString(l), "US-ASCII");
            byte[] byArray = new byte[32768];
            for (l = file.length(); l > 0L; l -= (long)n) {
                int n2 = l >= 32768L ? 32768 : (int)l;
                n = bufferedInputStream.read(byArray, 0, n2);
                if (n == -1) {
                    throw new IOException("Unexpected end of stream from " + file + ".");
                }
                loggedDataOutputStream.write(byArray, 0, n);
            }
            loggedDataOutputStream.flush();
            Object var10_8 = null;
            if (bufferedInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (bufferedInputStream == null) throw throwable;
            try {
                bufferedInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw throwable;
        }
        try {
            bufferedInputStream.close();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void writeTextFile(String string, String string2, LoggedDataInputStream loggedDataInputStream, int n) throws IOException {
        this.writeAndPostProcessTextFile(string, string2, loggedDataInputStream, n, this.getWriteTextFilePreprocessor());
    }

    public void writeRcsDiffFile(String string, String string2, LoggedDataInputStream loggedDataInputStream, int n) throws IOException {
        this.writeAndPostProcessTextFile(string, string2, loggedDataInputStream, n, this.getWriteRcsDiffFilePreprocessor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeAndPostProcessTextFile(String string, String string2, LoggedDataInputStream loggedDataInputStream, int n, WriteTextFilePreprocessor writeTextFilePreprocessor) throws IOException {
        File file = new File(string);
        boolean bl = this.resetReadOnly(file);
        this.createNewFile(file);
        File file2 = File.createTempFile("cvsCRLF", "tmp");
        try {
            Object object;
            block14: {
                BufferedOutputStream bufferedOutputStream = null;
                try {
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                    object = new byte[32768];
                    while (n > 0) {
                        int n2 = n >= 32768 ? 32768 : n;
                        if ((n2 = loggedDataInputStream.read((byte[])object, 0, n2)) == -1) {
                            throw new IOException("Unexpected end of stream: " + string + "\nMissing " + n + " bytes. Probably network communication failure.\nPlease try again.");
                        }
                        n -= n2;
                        ((OutputStream)bufferedOutputStream).write((byte[])object, 0, n2);
                    }
                    Object var13_12 = null;
                    if (bufferedOutputStream == null) break block14;
                }
                catch (Throwable throwable) {
                    Object var13_13 = null;
                    if (bufferedOutputStream == null) throw throwable;
                    try {
                        ((OutputStream)bufferedOutputStream).close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException iOException) {}
                ((OutputStream)bufferedOutputStream).close();
            }
            object = this.getProcessedInputStream(file2);
            try {
                writeTextFilePreprocessor.copyTextFileToLocation((InputStream)object, file, new StreamProvider(file));
            }
            finally {
                ((InputStream)object).close();
            }
            if (this.modifiedDate != null) {
                file.setLastModified(this.modifiedDate.getTime());
                this.modifiedDate = null;
            }
        }
        finally {
            file2.delete();
        }
        if (!bl) return;
        FileUtils.setFileReadOnly(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBinaryFile(String string, String string2, LoggedDataInputStream loggedDataInputStream, int n) throws IOException {
        File file = new File(string);
        boolean bl = this.resetReadOnly(file);
        this.createNewFile(file);
        File file2 = new File(file.getParentFile(), "CVS");
        file2.mkdir();
        File file3 = File.createTempFile("cvsPostConversion", "tmp", file2);
        try {
            int n2;
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file3));
            byte[] byArray = new byte[32768];
            try {
                while (n > 0) {
                    int n3 = n >= 32768 ? 32768 : n;
                    n2 = loggedDataInputStream.read(byArray, 0, n3);
                    if (n2 == -1) {
                        throw new IOException("Unexpected end of stream: " + string + "\nMissing " + n + " bytes. Probably network communication failure.\nPlease try again.");
                    }
                    if (n2 < 0) {
                        break;
                    }
                    n -= n2;
                    bufferedOutputStream.write(byArray, 0, n2);
                }
            }
            finally {
                bufferedOutputStream.close();
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getProcessedInputStream(file3));
            bufferedOutputStream = new BufferedOutputStream(this.createOutputStream(file));
            try {
                n2 = bufferedInputStream.read(byArray, 0, 32768);
                while (n2 > 0) {
                    bufferedOutputStream.write(byArray, 0, n2);
                    n2 = bufferedInputStream.read(byArray, 0, 32768);
                }
            }
            finally {
                bufferedOutputStream.close();
                bufferedInputStream.close();
            }
            if (this.modifiedDate != null) {
                file.setLastModified(this.modifiedDate.getTime());
                this.modifiedDate = null;
            }
        }
        finally {
            file3.delete();
        }
        if (bl) {
            FileUtils.setFileReadOnly(file, true);
        }
    }

    protected boolean createNewFile(File file) throws IOException {
        file.getParentFile().mkdirs();
        return file.createNewFile();
    }

    protected OutputStream createOutputStream(File file) throws IOException {
        return new FileOutputStream(file);
    }

    private boolean resetReadOnly(File file) throws IOException {
        boolean bl;
        boolean bl2 = bl = this.globalOptions != null && this.globalOptions.isCheckedOutFilesReadOnly();
        if (file.exists() && bl) {
            boolean bl3 = bl = !file.canWrite();
            if (bl) {
                FileUtils.setFileReadOnly(file, false);
            }
        }
        return bl;
    }

    public void removeLocalFile(String string) throws IOException {
        File file = new File(string);
        if (file.exists() && !file.delete()) {
            System.err.println("Could not delete file " + file.getAbsolutePath());
        }
    }

    public void renameLocalFile(String string, String string2) throws IOException {
        File file = new File(string);
        File file2 = new File(file.getParentFile(), string2);
        file.renameTo(file2);
    }

    public void setNextFileDate(Date date) {
        this.modifiedDate = date;
    }

    public void setGlobalOptions(GlobalOptions globalOptions) {
        BugLog.getInstance().assertNotNull(globalOptions);
        this.globalOptions = globalOptions;
        this.transmitTextFilePreprocessor.setTempDir(globalOptions.getTempDir());
    }

    private class StreamProvider
    implements OutputStreamProvider {
        private final File file;

        public StreamProvider(File file) {
            this.file = file;
        }

        public OutputStream createOutputStream() throws IOException {
            return DefaultFileHandler.this.createOutputStream(this.file);
        }
    }
}

