/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.Plugins;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.HttpDownloader;
import org.sonar.api.utils.IocContainer;
import org.sonar.api.utils.ServerHttpClient;
import org.sonar.batch.DefaultResourceCreationLock;
import org.sonar.batch.ProjectBatch;
import org.sonar.batch.ProjectTree;
import org.sonar.batch.ServerMetadata;
import org.sonar.batch.bootstrap.BatchPluginRepository;
import org.sonar.batch.bootstrap.BootstrapClassLoader;
import org.sonar.batch.bootstrap.ExtensionDownloader;
import org.sonar.batch.bootstrap.TempDirectories;
import org.sonar.batch.components.PastMeasuresLoader;
import org.sonar.batch.components.PastSnapshotFinder;
import org.sonar.batch.components.PastSnapshotFinderByDate;
import org.sonar.batch.components.PastSnapshotFinderByDays;
import org.sonar.batch.components.PastSnapshotFinderByPreviousAnalysis;
import org.sonar.batch.components.PastSnapshotFinderByVersion;
import org.sonar.batch.index.DefaultIndex;
import org.sonar.batch.index.DefaultPersistenceManager;
import org.sonar.batch.index.DefaultResourcePersister;
import org.sonar.batch.index.DependencyPersister;
import org.sonar.batch.index.EventPersister;
import org.sonar.batch.index.LinkPersister;
import org.sonar.batch.index.MeasurePersister;
import org.sonar.batch.index.SourcePersister;
import org.sonar.batch.index.ViolationPersister;
import org.sonar.core.components.CacheMetricFinder;
import org.sonar.core.components.CacheRuleFinder;
import org.sonar.core.plugin.JpaPluginDao;
import org.sonar.jpa.dao.MeasuresDao;
import org.sonar.jpa.session.DatabaseSessionProvider;
import org.sonar.jpa.session.DriverDatabaseConnector;
import org.sonar.jpa.session.ThreadLocalDatabaseSessionFactory;

public class Batch {
    private static final Logger LOG = LoggerFactory.getLogger(Batch.class);
    private Configuration configuration;
    private Object[] components;

    public Batch(Configuration configuration, Object ... components) {
        this.configuration = configuration;
        this.components = components;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        MutablePicoContainer container = null;
        try {
            container = this.buildPicoContainer();
            container.start();
            this.analyzeModules(container);
        }
        finally {
            if (container != null) {
                container.stop();
            }
        }
    }

    private void analyzeModules(MutablePicoContainer container) {
        MutablePicoContainer batchContainer = container.makeChildContainer();
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(ProjectTree.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(DefaultResourceCreationLock.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(DefaultIndex.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(DefaultPersistenceManager.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(DependencyPersister.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(EventPersister.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(LinkPersister.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(MeasurePersister.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(DefaultResourcePersister.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(SourcePersister.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(ViolationPersister.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(JpaPluginDao.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(BatchPluginRepository.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(Plugins.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(ServerHttpClient.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(MeasuresDao.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(CacheRuleFinder.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(CacheMetricFinder.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(PastSnapshotFinderByDate.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(PastSnapshotFinderByDays.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(PastSnapshotFinderByPreviousAnalysis.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(PastSnapshotFinderByVersion.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(PastMeasuresLoader.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(PastSnapshotFinder.class);
        batchContainer.start();
        ProjectTree projectTree = (ProjectTree)batchContainer.getComponent(ProjectTree.class);
        DefaultIndex index = (DefaultIndex)((Object)batchContainer.getComponent(DefaultIndex.class));
        this.analyzeModule(batchContainer, index, projectTree.getRootProject());
    }

    private MutablePicoContainer buildPicoContainer() {
        MutablePicoContainer container = IocContainer.buildPicoContainer();
        this.register(container, this.configuration);
        this.register(container, ServerMetadata.class);
        this.register(container, TempDirectories.class);
        this.register(container, HttpDownloader.class);
        this.register(container, ExtensionDownloader.class);
        this.register(container, BootstrapClassLoader.class);
        URLClassLoader bootstrapClassLoader = ((BootstrapClassLoader)container.getComponent(BootstrapClassLoader.class)).getClassLoader();
        Thread.currentThread().setContextClassLoader(bootstrapClassLoader);
        this.register(container, new DriverDatabaseConnector(this.configuration, (ClassLoader)bootstrapClassLoader));
        this.register(container, ThreadLocalDatabaseSessionFactory.class);
        container.as(new Properties[]{Characteristics.CACHE}).addAdapter((ComponentAdapter)new DatabaseSessionProvider());
        for (Object component : this.components) {
            this.register(container, component);
        }
        return container;
    }

    private void register(MutablePicoContainer container, Object component) {
        container.as(new Properties[]{Characteristics.CACHE}).addComponent(component);
    }

    private void analyzeModule(MutablePicoContainer container, DefaultIndex index, Project project) {
        for (Project module : project.getModules()) {
            this.analyzeModule(container, index, module);
        }
        LOG.info("-------------  Analyzing {}", (Object)project.getName());
        Object[] exclusionPatterns = project.getExclusionPatterns();
        if (exclusionPatterns != null && exclusionPatterns.length > 0) {
            LOG.info("Excluded sources : {}", (Object)Arrays.toString(exclusionPatterns));
        }
        new ProjectBatch(container).execute(index, project);
    }
}

