/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import org.picocontainer.injectors.ProviderAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.api.rules.ActiveRule;
import org.sonar.jpa.dao.ProfilesDao;

public class ProfileProvider
extends ProviderAdapter {
    public static final String PARAM_PROFILE = "sonar.profile";
    private static final Logger LOG = LoggerFactory.getLogger(ProfileProvider.class);
    private RulesProfile profile;

    public RulesProfile provide(Project project, ProfilesDao dao) {
        if (this.profile == null) {
            String profileName = (String)project.getProperty(PARAM_PROFILE);
            if (profileName == null) {
                Project root = project.getRoot();
                this.profile = dao.getActiveProfile(root.getLanguageKey(), root.getKey());
                if (this.profile == null) {
                    throw new RuntimeException("Quality profile not found for " + root.getKey() + ", language " + root.getLanguageKey());
                }
            } else {
                this.profile = dao.getProfile(project.getLanguageKey(), profileName);
                if (this.profile == null) {
                    throw new RuntimeException("Quality profile not found : " + profileName + ", language " + project.getLanguageKey());
                }
            }
            this.profile.getActiveRules().size();
            for (ActiveRule activeRule : this.profile.getActiveRules()) {
                activeRule.getActiveRuleParams().size();
                activeRule.getRule().getParams().size();
            }
            this.profile.getAlerts().size();
            LOG.info("Selected quality profile : {}", (Object)this.profile);
        }
        return this.profile;
    }
}

