/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.xslthl.Block;
import net.sf.xslthl.StyledBlock;

class CharIter {
    private String s;
    private int i = 0;
    private int l;
    private int mark = 0;
    private Matcher matcher;

    CharIter(String string) {
        this.s = string;
        this.l = string.length();
    }

    int getMark() {
        return this.mark;
    }

    void setMark() {
        this.mark = this.i;
    }

    void setMark(int n) {
        this.mark = n;
    }

    boolean isMarked() {
        return this.mark < this.i;
    }

    String getMarked() {
        if (this.i > this.l) {
            this.i = this.l;
        }
        return this.s.substring(this.mark, this.i);
    }

    Block markedToBlock() {
        Block block = new Block(this.getMarked());
        this.setMark();
        return block;
    }

    Block markedToStyledBlock(String string) {
        StyledBlock styledBlock = new StyledBlock(this.getMarked(), string);
        this.setMark();
        return styledBlock;
    }

    void moveNext() {
        ++this.i;
    }

    void moveNext(int n) {
        this.i += n;
    }

    void moveNextAndMark() {
        this.moveNext();
        this.setMark();
    }

    void moveToEnd() {
        this.i = this.l;
    }

    boolean finished() {
        return this.i >= this.l;
    }

    Character current() {
        return Character.valueOf(this.s.charAt(this.i));
    }

    Character next() {
        if (this.i + 1 < this.l) {
            return Character.valueOf(this.s.charAt(this.i + 1));
        }
        return null;
    }

    Character next(int n) {
        if (this.i + n < this.l) {
            return Character.valueOf(this.s.charAt(this.i + n));
        }
        return null;
    }

    Character prev() {
        if (this.i > 0) {
            return Character.valueOf(this.s.charAt(this.i - 1));
        }
        return null;
    }

    Character prev(int n) {
        if (this.i - n >= 0) {
            return Character.valueOf(this.s.charAt(this.i - n));
        }
        return null;
    }

    boolean startsWith(String string) {
        return this.s.startsWith(string, this.i);
    }

    boolean startsWith(String string, int n) {
        return this.s.startsWith(string, this.i + n);
    }

    void createMatcher(Pattern pattern) {
        this.matcher = pattern.matcher(this.s);
    }

    boolean find() {
        boolean bl = this.matcher.find();
        if (bl) {
            this.i = this.matcher.start();
        } else {
            this.moveToEnd();
        }
        return bl;
    }

    void markMatched() {
        this.setMark(this.i);
        this.i = this.matcher.end();
    }

    int remaining() {
        if (this.i < this.l) {
            return this.l - this.i;
        }
        return 0;
    }

    int indexOf(String string) {
        int n = this.s.indexOf(string, this.i);
        return n < 0 ? -1 : n - this.i;
    }
}

