/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;
import net.n3.nanoxml.XMLElement;

public class AndCondition
extends Condition {
    private static final long serialVersionUID = -5854944262991488370L;
    protected Condition leftoperand;
    protected Condition rightoperand;

    public AndCondition() {
    }

    public AndCondition(Condition condition, Condition condition2) {
        this.leftoperand = condition;
        this.rightoperand = condition2;
    }

    public void readFromXML(XMLElement xMLElement) {
        try {
            if (xMLElement.getChildrenCount() != 2) {
                Debug.log("and-condition needs two conditions as operands");
                return;
            }
            this.leftoperand = RulesEngine.analyzeCondition(xMLElement.getChildAtIndex(0));
            this.rightoperand = RulesEngine.analyzeCondition(xMLElement.getChildAtIndex(1));
        }
        catch (Exception exception) {
            Debug.log("missing element in and-condition");
        }
    }

    public boolean isTrue() {
        return this.leftoperand.isTrue() && this.rightoperand.isTrue();
    }

    public String getDependenciesDetails() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.id);
        stringBuffer.append(" depends on:<ul><li>");
        stringBuffer.append(this.leftoperand.getDependenciesDetails());
        stringBuffer.append("</li> AND <li>");
        stringBuffer.append(this.rightoperand.getDependenciesDetails());
        stringBuffer.append("</li></ul>");
        return stringBuffer.toString();
    }
}

