/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;
import net.n3.nanoxml.XMLElement;

public class OrCondition
extends Condition {
    private static final long serialVersionUID = 8341350377205144199L;
    protected Condition leftoperand;
    protected Condition rightoperand;

    public OrCondition() {
    }

    public OrCondition(Condition condition, Condition condition2) {
        this.leftoperand = condition;
        this.rightoperand = condition2;
    }

    public void readFromXML(XMLElement xMLElement) {
        try {
            if (xMLElement.getChildrenCount() != 2) {
                Debug.log("or-condition needs two conditions as operands");
                return;
            }
            this.leftoperand = RulesEngine.analyzeCondition(xMLElement.getChildAtIndex(0));
            this.rightoperand = RulesEngine.analyzeCondition(xMLElement.getChildAtIndex(1));
        }
        catch (Exception exception) {
            Debug.log("missing element in or-condition");
        }
    }

    public boolean isTrue() {
        return this.leftoperand.isTrue() || this.rightoperand.isTrue();
    }

    public String getDependenciesDetails() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.id);
        stringBuffer.append(" depends on:<ul><li>");
        stringBuffer.append(this.leftoperand.getDependenciesDetails());
        stringBuffer.append("</li> OR <li>");
        stringBuffer.append(this.rightoperand.getDependenciesDetails());
        stringBuffer.append("</li></ul>");
        return stringBuffer.toString();
    }
}

