/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Stack;
import java.util.Vector;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLBuilder;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLBuilderFactory;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLException;
import net.n3.nanoxml.XMLParseException;

public class XIncludeXMLBuilder
extends StdXMLBuilder {
    public static final String INCLUDE_NS = "http://www.w3.org/2001/XInclude";
    public static final String INCLUDE_ELEMENT = "xinclude";
    public static final String HREF_ATTRIB = "href";
    public static final String XPOINTER_ATTRIB = "xpointer";
    public static final String ENCODING_ATTRIB = "encoding";
    public static final String ACCEPT_ENCODING = "accept";
    public static final String FALLBACK_ELEMENT = "xfallback";
    public static final String PARSE_ATTRIB = "parse";
    public static final String FRAGMENT_NS = "http://izpack.org/izpack/fragment";
    public static final String FRAGMENT = "xfragment";

    public void endElement(String string, String string2, String string3) {
        XMLElement xMLElement = this.getCurrentElement();
        super.endElement(string, string2, string3);
        this.processXInclude(xMLElement);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processXInclude(XMLElement xMLElement) {
        if (!INCLUDE_ELEMENT.equals(xMLElement.getName())) return;
        Vector<XMLElement> vector = xMLElement.getChildrenNamed(FALLBACK_ELEMENT);
        if (xMLElement.getChildrenCount() != vector.size() || vector.size() > 1) {
            throw new RuntimeException(new XMLParseException(xMLElement.getSystemID(), xMLElement.getLineNr(), "xinclude can optionally have a single xfragment as a child"));
        }
        boolean bl = false;
        String string = xMLElement.getAttribute(HREF_ATTRIB, "");
        if (!string.equals("")) {
            IXMLReader iXMLReader = null;
            try {
                iXMLReader = this.getReader(xMLElement);
            }
            catch (Exception exception) {
                iXMLReader = this.handleFallback(xMLElement);
                bl = true;
            }
            String string2 = xMLElement.getAttribute(PARSE_ATTRIB, "xml");
            if ("text".equals(string2) && !bl) {
                this.includeText(xMLElement, iXMLReader);
                return;
            } else {
                if (!"xml".equals(string2)) throw new RuntimeException(new XMLParseException(xMLElement.getSystemID(), xMLElement.getLineNr(), "parse attribute of xinclude must be \"xml\" or \"text\" but was " + string2));
                this.includeXML(xMLElement, iXMLReader);
            }
            return;
        }
        if (xMLElement.hasAttribute(XPOINTER_ATTRIB)) return;
        throw new RuntimeException(new XMLParseException(xMLElement.getSystemID(), xMLElement.getLineNr(), "xpointermust be specified if href is empty or missing"));
    }

    private IXMLReader handleFallback(XMLElement xMLElement) {
        Vector<XMLElement> vector = xMLElement.getChildrenNamed(FALLBACK_ELEMENT);
        if (vector.size() == 1) {
            XMLElement xMLElement2 = vector.get(0);
            String string = xMLElement2.getContent();
            if (string != null) {
                string = string.trim();
            }
            if ("".equals(string) || string == null) {
                string = "<?xml version=\"1.0\" encoding=\"iso-8859-1\" standalone=\"yes\" ?><xfragment/>";
            }
            return StdXMLReader.stringReader(string);
        }
        throw new RuntimeException(new XMLParseException(xMLElement.getSystemID(), xMLElement.getLineNr(), "could not load content"));
    }

    private void includeXML(XMLElement xMLElement, IXMLReader iXMLReader) {
        try {
            Stack<XMLElement> stack = this.getStack();
            StdXMLParser stdXMLParser = new StdXMLParser();
            stdXMLParser.setBuilder(XMLBuilderFactory.createXMLBuilder());
            stdXMLParser.setReader(iXMLReader);
            stdXMLParser.setValidator(new NonValidator());
            XMLElement xMLElement2 = (XMLElement)stdXMLParser.parse();
            if (stack.isEmpty()) {
                this.setRootElement(xMLElement2);
            } else {
                XMLElement xMLElement3 = stack.peek();
                xMLElement3.removeChild(xMLElement);
                if (FRAGMENT.equals(xMLElement2.getName())) {
                    Vector vector = xMLElement2.getChildren();
                    for (XMLElement xMLElement4 : vector) {
                        xMLElement3.addChild(xMLElement4);
                    }
                } else {
                    xMLElement3.addChild(xMLElement2);
                }
            }
        }
        catch (XMLException xMLException) {
            throw new RuntimeException(new XMLParseException(xMLElement.getSystemID(), xMLElement.getLineNr(), xMLException.getMessage()));
        }
    }

    private void includeText(XMLElement xMLElement, IXMLReader iXMLReader) {
        if (xMLElement.getAttribute(XPOINTER_ATTRIB) != null) {
            throw new RuntimeException(new XMLParseException("xpointer cannot be used with parse='text'"));
        }
        Stack<XMLElement> stack = this.getStack();
        if (stack.isEmpty()) {
            throw new RuntimeException(new XMLParseException(xMLElement.getSystemID(), xMLElement.getLineNr(), "cannot include text as the root node"));
        }
        XMLElement xMLElement2 = stack.peek();
        xMLElement2.removeChild(xMLElement);
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while (!iXMLReader.atEOF()) {
                stringBuffer.append(iXMLReader.read());
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(new XMLParseException(xMLElement.getSystemID(), xMLElement.getLineNr(), iOException.getMessage()));
        }
        if (xMLElement2.getChildrenCount() == 0) {
            xMLElement2.setContent(stringBuffer.toString());
        } else {
            XMLElement xMLElement3 = new XMLElement();
            xMLElement3.setContent(stringBuffer.toString());
            xMLElement2.addChild(xMLElement3);
        }
    }

    private IXMLReader getReader(XMLElement xMLElement) throws XMLParseException, IOException {
        String string = xMLElement.getAttribute(HREF_ATTRIB);
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                uRL = string.charAt(0) == '/' ? new URL("file://" + string) : new URL(new URL(xMLElement.getSystemID()), string);
            }
            catch (MalformedURLException malformedURLException2) {
                new XMLParseException(xMLElement.getSystemID(), xMLElement.getLineNr(), "malformed url '" + string + "'");
            }
        }
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof HttpURLConnection && xMLElement.hasAttribute(ENCODING_ATTRIB)) {
            uRLConnection.setRequestProperty(ACCEPT_ENCODING, xMLElement.getAttribute(ENCODING_ATTRIB));
        }
        InputStream inputStream = uRLConnection.getInputStream();
        InputStreamReader inputStreamReader = null;
        inputStreamReader = xMLElement.getAttribute(PARSE_ATTRIB, "xml").equals("text") && xMLElement.hasAttribute(ENCODING_ATTRIB) ? new InputStreamReader(inputStream, xMLElement.getAttribute(ENCODING_ATTRIB, "")) : new InputStreamReader(inputStream);
        StdXMLReader stdXMLReader = new StdXMLReader(inputStreamReader);
        stdXMLReader.setSystemID(uRL.toExternalForm());
        return stdXMLReader;
    }

    public void startBuilding(String string, int n) {
        super.startBuilding(string, n);
    }
}

