/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cobertura.tasks;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.cobertura.configuration.ConfigInstrumentation;
import org.codehaus.mojo.cobertura.tasks.AbstractTask;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentTask
extends AbstractTask {
    private ConfigInstrumentation config = null;
    private File dataFile = null;
    private File destinationDir = null;

    public InstrumentTask() {
        super("net.sourceforge.cobertura.instrument.Main");
    }

    @Override
    public void execute() throws MojoExecutionException {
        this.cmdLineArgs.setUseCommandsFile(true);
        if (StringUtils.isNotEmpty((String)this.config.getMaxmem())) {
            this.setMaxmem(this.config.getMaxmem());
        }
        if (this.dataFile != null) {
            this.cmdLineArgs.addArg("--datafile", this.dataFile.getAbsolutePath());
        }
        if (this.destinationDir != null) {
            this.cmdLineArgs.addArg("--destination", this.destinationDir.getAbsolutePath());
        }
        for (String ignore : this.config.getIgnores()) {
            this.cmdLineArgs.addArg("--ignore", ignore);
        }
        String includes = this.joinCludes(this.config.getIncludes());
        String excludes = this.joinCludes(this.config.getExcludes());
        String defaultExcludes = this.joinCludes(FileUtils.getDefaultExcludesAsList());
        excludes = StringUtils.isNotEmpty((String)excludes) ? excludes + "," + defaultExcludes : defaultExcludes;
        try {
            List filenames;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Config : " + this.config));
                this.getLog().debug((CharSequence)("Basedir: " + this.config.getBasedir()));
                this.getLog().debug((CharSequence)("Include: " + includes));
                this.getLog().debug((CharSequence)("Exclude: " + excludes));
                this.getLog().debug((CharSequence)("Max Mem: " + this.config.getMaxmem()));
            }
            if ((filenames = FileUtils.getFileNames((File)this.config.getBasedir(), (String)includes, (String)excludes, (boolean)false)).isEmpty()) {
                this.getLog().warn((CharSequence)"No files to instrument.");
                return;
            }
            this.cmdLineArgs.addArg("--basedir", this.config.getBasedir().getAbsolutePath());
            for (String filename : filenames) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("To Instrument: " + filename));
                }
                this.cmdLineArgs.addArg(filename);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to obtain file list from includes/excludes.", (Exception)e);
        }
        int returnCode = this.executeJava();
        if (returnCode == 0) {
            if (!this.isQuiet()) {
                this.getLog().info((CharSequence)"Instrumentation was successful.");
            }
        } else {
            throw new MojoExecutionException("Unable to instrument project.");
        }
    }

    public ConfigInstrumentation getConfig() {
        return this.config;
    }

    public File getDataFile() {
        return this.dataFile;
    }

    public File getDestinationDir() {
        return this.destinationDir;
    }

    public String joinCludes(List<String> cludes) {
        StringBuffer sb = new StringBuffer();
        Iterator<String> it = cludes.iterator();
        while (it.hasNext()) {
            String clude = it.next();
            sb.append(clude);
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public void setConfig(ConfigInstrumentation config) {
        this.config = config;
    }

    public void setDataFile(File dataFile) {
        this.dataFile = dataFile;
    }

    public void setDestinationDir(File destinationDir) {
        this.destinationDir = destinationDir;
    }
}

