/*
 * Decompiled with CFR 0.152.
 */
package com.humaorie.dollar;

import com.humaorie.dollar.ArrayWrapper;
import com.humaorie.dollar.ConcatWrapper;
import com.humaorie.dollar.Dollar;
import com.humaorie.dollar.FillWrapper;
import com.humaorie.dollar.LazyFilterWrapper;
import com.humaorie.dollar.LazyMappedWrapper;
import com.humaorie.dollar.ListWrapper;
import com.humaorie.dollar.Preconditions;
import com.humaorie.dollar.RepeatWrapper;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;

public abstract class AbstractWrapper<T>
implements Dollar.Wrapper<T> {
    @Override
    public abstract Dollar.Wrapper<T> copy();

    @Override
    public abstract int size();

    @Override
    public Dollar.Wrapper<T> concat(Dollar.Wrapper<T> wrapper) {
        return new ConcatWrapper().concat(this).concat(wrapper);
    }

    @Override
    public Dollar.Wrapper<T> concat(T ... items) {
        return new ConcatWrapper().concat(this).concat(items);
    }

    @Override
    public Dollar.Wrapper<T> concat(Collection<T> items) {
        return new ConcatWrapper().concat(this).concat(items);
    }

    @Override
    public Dollar.Wrapper<T> repeat(int n) {
        return new RepeatWrapper(this, n);
    }

    @Override
    public Dollar.Wrapper<T> fill(T object) {
        return new FillWrapper<T>(object, this.size());
    }

    @Override
    public Dollar.Wrapper<T> slice(int j) {
        return this.slice(0, j);
    }

    @Override
    public Dollar.Wrapper<T> slice(int i, int j) {
        return new ListWrapper<T>(this.toList()).slice(i, j);
    }

    @Override
    public Dollar.Wrapper<T> shuffle() {
        return this.shuffle(new Random());
    }

    @Override
    public Dollar.Wrapper<T> shuffle(Random random) {
        Preconditions.require(random != null, "random must be non-null", new Object[0]);
        return new ListWrapper(this).shuffle(random);
    }

    @Override
    public Dollar.Wrapper<T> sort() {
        return new ListWrapper(this).sort();
    }

    @Override
    public Dollar.Wrapper<T> sort(Comparator<T> comparator) {
        return new ListWrapper<T>(this).sort(comparator);
    }

    @Override
    public Iterator<T> iterator() {
        return new ListWrapper(this).iterator();
    }

    @Override
    public Dollar.Wrapper<T> reverse() {
        return new ListWrapper(this).reverse();
    }

    @Override
    public String join() {
        return this.join("");
    }

    @Override
    public String join(String separator) {
        Preconditions.require(separator != null, "separator must be non-null", new Object[0]);
        Separator sep = new Separator(separator);
        StringBuilder sb = new StringBuilder();
        for (T item : this) {
            sb.append(sep).append(item);
        }
        return sb.toString();
    }

    @Override
    public List<T> toList() {
        return this.toList(LinkedList.class);
    }

    @Override
    public List<T> toList(Class<? extends List> concreteListClass) {
        List<T> list = AbstractWrapper.createList(concreteListClass);
        AbstractWrapper.addToCollection(list, this);
        return list;
    }

    @Override
    public Set<T> toSet() {
        return this.toSet(HashSet.class);
    }

    @Override
    public Set<T> toSet(Class<? extends Set> concreteSetClass) {
        Set<T> set = AbstractWrapper.createSet(concreteSetClass);
        AbstractWrapper.addToCollection(set, this);
        return set;
    }

    @Override
    public T[] toArray() {
        return AbstractWrapper.iterableToArray(this, this.size());
    }

    @Override
    public T[] toArray(Class<T> concreteClass) {
        return AbstractWrapper.iterableToArray(this, concreteClass, this.size());
    }

    @Override
    public Dollar.ArrayWrapper<T> convert() {
        T[] array = this.toArray();
        Class<?> componentType = array.getClass().getComponentType();
        if (componentType.equals(Byte.class)) {
            return new ArrayWrapper.ByteArrayWrapper((Byte[])array);
        }
        if (componentType.equals(Short.class)) {
            return new ArrayWrapper.ShortArrayWrapper((Short[])array);
        }
        if (componentType.equals(Integer.class)) {
            return new ArrayWrapper.IntegerArrayWrapper((Integer[])array);
        }
        if (componentType.equals(Long.class)) {
            return new ArrayWrapper.LongArrayWrapper((Long[])array);
        }
        if (componentType.equals(Character.class)) {
            return new ArrayWrapper.CharArrayWrapper((Character[])array);
        }
        if (componentType.equals(Boolean.class)) {
            return new ArrayWrapper.BooleanArrayWrapper((Boolean[])array);
        }
        if (componentType.equals(Float.class)) {
            return new ArrayWrapper.FloatArrayWrapper((Float[])array);
        }
        if (componentType.equals(Double.class)) {
            return new ArrayWrapper.DoubleArrayWrapper((Double[])array);
        }
        throw new IllegalArgumentException("cannot convert() array of " + componentType.toString());
    }

    @Override
    public Dollar.Wrapper<T> filter(Dollar.Function<Boolean, T> predicate) {
        return new LazyFilterWrapper<T>(this, predicate);
    }

    @Override
    public Dollar.Wrapper<T> reject(Dollar.Function<Boolean, T> predicate) {
        return new LazyFilterWrapper<T>(this, Dollar.not(predicate));
    }

    @Override
    public boolean all(Dollar.Function<Boolean, T> predicate) {
        return this.findIt(Dollar.not(predicate)) == null;
    }

    @Override
    public boolean any(Dollar.Function<Boolean, T> predicate) {
        return this.findIt(predicate) != null;
    }

    @Override
    public T find(Dollar.Function<Boolean, T> predicate) {
        T t = this.findIt(predicate);
        if (t == null) {
            throw new NoSuchElementException();
        }
        return t;
    }

    private T findIt(Dollar.Function<Boolean, T> predicate) {
        for (T t : this) {
            if (!predicate.call(t).booleanValue()) continue;
            return t;
        }
        return null;
    }

    @Override
    public int indexOf(Dollar.Function<Boolean, T> predicate) {
        int i = 0;
        for (T t : this) {
            if (predicate.call(t).booleanValue()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public <R> Dollar.Wrapper<R> map(Dollar.Function<R, T> function) {
        return new LazyMappedWrapper<R, T>(this, function);
    }

    @Override
    public Dollar.Wrapper<T> each(Dollar.Function<T, T> function) {
        for (T item : this) {
            function.call(item);
        }
        return this;
    }

    @Override
    public <R> R reduce(R initial, Dollar.Function2<R, T, R> function) {
        R value = initial;
        for (T item : this) {
            value = function.call(item, value);
        }
        return value;
    }

    @Override
    public <R, V> R reduce(R initial, Dollar.Function3<R, T, R, V> function, V context) {
        R value = initial;
        for (T item : this) {
            value = function.call(item, value, context);
        }
        return value;
    }

    static <T> T[] iterableToArray(Iterable<T> iterable, int size) {
        Class<?> concreteClass = null;
        for (T item : iterable) {
            if (item == null) continue;
            concreteClass = item.getClass();
            break;
        }
        return AbstractWrapper.iterableToArray(iterable, concreteClass, size);
    }

    static <T> T[] iterableToArray(Iterable<T> iterable, Class<?> concreteClass, int size) {
        if (concreteClass == null) {
            return null;
        }
        Object[] array = (Object[])Array.newInstance(concreteClass, size);
        int i = 0;
        for (T item : iterable) {
            array[i++] = item;
        }
        return array;
    }

    static <T> void addToCollection(Collection<T> collection, T ... array) {
        AbstractWrapper.addToCollection(collection, new ArrayWrapper<T>(array));
    }

    static <T> void addToCollection(Collection<T> collection, Iterable<T> iterable) {
        for (T item : iterable) {
            collection.add(item);
        }
    }

    static IllegalArgumentException illegalConcreteClass(Class<?> concreteClass) {
        return new IllegalArgumentException(String.format("class '%s' must have a public, no-args constructor", concreteClass.getName()));
    }

    static void assertNoArgsConstructor(Class<?> concreteClass) {
        try {
            Constructor<?> noArgsConstructor = concreteClass.getConstructor(new Class[0]);
            if (noArgsConstructor == null) {
                throw AbstractWrapper.illegalConcreteClass(concreteClass);
            }
        }
        catch (NoSuchMethodException ex) {
            throw AbstractWrapper.illegalConcreteClass(concreteClass);
        }
        catch (SecurityException ex) {
            throw AbstractWrapper.illegalConcreteClass(concreteClass);
        }
    }

    static Object newInstanceOf(Class<?> concreteClass) {
        try {
            return concreteClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw AbstractWrapper.illegalConcreteClass(concreteClass);
        }
        catch (IllegalAccessException ex) {
            throw AbstractWrapper.illegalConcreteClass(concreteClass);
        }
    }

    static <T> Set<T> createSet(Class<? extends Set> concreteSetClass) {
        AbstractWrapper.assertNoArgsConstructor(concreteSetClass);
        return (Set)AbstractWrapper.newInstanceOf(concreteSetClass);
    }

    static <T> List<T> createList(Class<? extends List> concreteListClass) {
        AbstractWrapper.assertNoArgsConstructor(concreteListClass);
        return (List)AbstractWrapper.newInstanceOf(concreteListClass);
    }

    protected static class Separator {
        private final String separator;
        private boolean wasCalled;

        public Separator(String separator) {
            this.separator = separator;
            this.wasCalled = false;
        }

        public String toString() {
            if (!this.wasCalled) {
                this.wasCalled = true;
                return "";
            }
            return this.separator;
        }
    }
}

