/*
 * Decompiled with CFR 0.152.
 */
package com.humaorie.dollar;

import com.humaorie.dollar.AbstractWrapper;
import com.humaorie.dollar.CharSequenceWrapper;
import com.humaorie.dollar.Dollar;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;

public class CharRangeWrapper
extends AbstractWrapper<Character> {
    private final char from;
    private final char to;

    public CharRangeWrapper(char from, char to) {
        this.from = from;
        this.to = to;
    }

    @Override
    public Iterator<Character> iterator() {
        if (this.from < this.to) {
            return new ForwardIterator();
        }
        return new ReverseIterator();
    }

    @Override
    public Dollar.Wrapper<Character> copy() {
        return new CharRangeWrapper(this.from, this.to);
    }

    @Override
    public int size() {
        return Math.abs(this.to - this.from) + 1;
    }

    @Override
    public Dollar.Wrapper<Character> shuffle(Random random) {
        return new CharSequenceWrapper(this.join()).shuffle(random);
    }

    @Override
    public Dollar.Wrapper<Character> reverse() {
        return new CharRangeWrapper(this.to, this.from);
    }

    @Override
    public Dollar.Wrapper<Character> sort() {
        if (this.from < this.to) {
            return this;
        }
        return this.reverse();
    }

    public boolean equals(Object object) {
        if (object instanceof CharRangeWrapper) {
            CharRangeWrapper charRangeWrapper = (CharRangeWrapper)object;
            return charRangeWrapper.from == this.from && charRangeWrapper.to == this.to;
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash *= 53 + this.from;
        return hash *= 53 + this.to;
    }

    class ReverseIterator
    implements Iterator<Character> {
        private char i;

        ReverseIterator() {
            this.i = CharRangeWrapper.this.from;
        }

        @Override
        public boolean hasNext() {
            return this.i >= CharRangeWrapper.this.to;
        }

        @Override
        public Character next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            char c = this.i;
            this.i = (char)(c - '\u0001');
            return Character.valueOf(c);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported for CharRangeWrapper");
        }
    }

    class ForwardIterator
    implements Iterator<Character> {
        private char i;

        ForwardIterator() {
            this.i = CharRangeWrapper.this.from;
        }

        @Override
        public boolean hasNext() {
            return this.i <= CharRangeWrapper.this.to;
        }

        @Override
        public Character next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            char c = this.i;
            this.i = (char)(c + '\u0001');
            return Character.valueOf(c);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported for CharRangeWrapper");
        }
    }
}

