/*
 * Decompiled with CFR 0.152.
 */
package com.humaorie.dollar;

import com.humaorie.dollar.AbstractWrapper;
import com.humaorie.dollar.Dollar;
import com.humaorie.dollar.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class ConcatWrapper<T>
extends AbstractWrapper<T> {
    private final List<T> list;

    public ConcatWrapper() {
        this(new LinkedList());
    }

    public ConcatWrapper(List<T> list) {
        Preconditions.require(list != null, "list must be non-null", new Object[0]);
        this.list = list;
    }

    @Override
    public Dollar.Wrapper<T> concat(Collection<T> items) {
        Preconditions.require(items != null, "items must be non-null", new Object[0]);
        ConcatWrapper.addToCollection(this.list, items);
        return this;
    }

    @Override
    public Dollar.Wrapper<T> concat(T ... items) {
        Preconditions.require(items != null, "items must be non-null", new Object[0]);
        ConcatWrapper.addToCollection(this.list, items);
        return this;
    }

    @Override
    public Dollar.Wrapper<T> concat(Dollar.Wrapper<T> wrapper) {
        if (wrapper != null) {
            ConcatWrapper.addToCollection(this.list, wrapper);
        }
        return this;
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public Dollar.Wrapper<T> copy() {
        LinkedList copy = new LinkedList();
        ConcatWrapper.addToCollection(copy, this);
        return new ConcatWrapper(copy);
    }

    @Override
    public Dollar.Wrapper<T> reverse() {
        Collections.reverse(this.list);
        return this;
    }

    @Override
    public Dollar.Wrapper<T> shuffle(Random random) {
        Preconditions.require(random != null, "random must be non-null", new Object[0]);
        Collections.shuffle(this.list, random);
        return this;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<T> toList() {
        return this.list;
    }

    public boolean equals(Object object) {
        if (object instanceof ConcatWrapper) {
            ConcatWrapper concatWrapper = (ConcatWrapper)object;
            return this.list.equals(concatWrapper.list);
        }
        return false;
    }

    public int hashCode() {
        int hash = 11;
        return hash *= 59 + this.list.hashCode();
    }
}

