/*
 * Decompiled with CFR 0.152.
 */
package com.humaorie.dollar;

import com.humaorie.dollar.AbstractWrapper;
import com.humaorie.dollar.Dollar;
import com.humaorie.dollar.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;

public class FillWrapper<T>
extends AbstractWrapper<T> {
    private final T value;
    private final int size;

    public FillWrapper(T value, int size) {
        Preconditions.require(size > 0, "size must be positive", new Object[0]);
        this.value = value;
        this.size = size;
    }

    @Override
    public Dollar.Wrapper<T> copy() {
        return new FillWrapper<T>(this.value, this.size);
    }

    @Override
    public Iterator<T> iterator() {
        return new FillIterator<T>(this.value, this.size);
    }

    @Override
    public Dollar.Wrapper<T> repeat(int n) {
        Preconditions.require(n > 0, "n must be positive", new Object[0]);
        return new FillWrapper<T>(this.value, this.size * n);
    }

    @Override
    public Dollar.Wrapper<T> reverse() {
        return this;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Dollar.Wrapper<T> sort() {
        return this;
    }

    @Override
    public Dollar.Wrapper<T> shuffle(Random random) {
        return this;
    }

    @Override
    public Dollar.Wrapper<T> slice(int i, int j) {
        if (i >= 0 && j <= this.size) {
            return new FillWrapper<T>(this.value, j - i);
        }
        return this;
    }

    public boolean equals(Object object) {
        if (object instanceof FillWrapper) {
            FillWrapper fillWrapper = (FillWrapper)object;
            return this.value.equals(fillWrapper.value) && this.size == fillWrapper.size;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash *= 41 + this.value.hashCode();
        return hash *= 41 + this.size;
    }

    private static class FillIterator<T>
    implements Iterator<T> {
        private final T value;
        private int size;

        public FillIterator(T value, int size) {
            this.value = value;
            this.size = size;
        }

        @Override
        public boolean hasNext() {
            return this.size > 0;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.size;
            return this.value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported for FillWrapper");
        }
    }
}

