/*
 * Decompiled with CFR 0.152.
 */
package com.humaorie.dollar;

import com.humaorie.dollar.AbstractDelegatingWrapper;
import com.humaorie.dollar.Box;
import com.humaorie.dollar.Dollar;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LazyFilterWrapper<T>
extends AbstractDelegatingWrapper<T> {
    private final Dollar.Function<Boolean, T> predicate;

    public LazyFilterWrapper(Dollar.Wrapper<T> d, Dollar.Function<Boolean, T> predicate) {
        super(d);
        this.predicate = predicate;
    }

    @Override
    public int size() {
        int s = 0;
        for (Object item : this.delegate) {
            if (!this.predicate.call(item).booleanValue()) continue;
            ++s;
        }
        return s;
    }

    @Override
    public Iterator<T> iterator() {
        return new LazyFilteringIterator(this.delegate.iterator(), this.predicate);
    }

    @Override
    public Dollar.Wrapper<T> copy() {
        return new LazyFilterWrapper(this.delegate.copy(), this.predicate);
    }

    public static class LazyFilteringIterator<T>
    implements Iterator<T> {
        private Box<T> box = Box.empty();
        private final Iterator<T> unfiltered;
        private final Dollar.Function<Boolean, T> predicate;

        public LazyFilteringIterator(Iterator<T> unfiltered, Dollar.Function<Boolean, T> predicate) {
            this.unfiltered = unfiltered;
            this.predicate = predicate;
        }

        protected void prefetch() {
            if (!this.box.isEmpty()) {
                return;
            }
            while (this.unfiltered.hasNext()) {
                T element = this.unfiltered.next();
                if (!this.predicate.call(element).booleanValue()) continue;
                this.box = Box.of(element);
                return;
            }
            this.box = Box.empty();
        }

        @Override
        public boolean hasNext() {
            this.prefetch();
            return !this.box.isEmpty();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T next = this.box.get();
            this.box = Box.empty();
            return next;
        }

        @Override
        public void remove() {
            this.unfiltered.remove();
        }
    }
}

