/*
 * Decompiled with CFR 0.152.
 */
package com.humaorie.dollar;

import com.humaorie.dollar.AbstractWrapper;
import com.humaorie.dollar.Dollar;
import com.humaorie.dollar.Preconditions;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class ListWrapper<T>
extends AbstractWrapper<T>
implements Dollar.ListWrapper<T> {
    protected List<T> list;

    public ListWrapper(List<T> list) {
        Preconditions.require(list != null, "list must be non-null", new Object[0]);
        this.list = list;
    }

    public ListWrapper(Iterable<T> iterable) {
        this.list = new LinkedList<T>();
        ListWrapper.addToCollection(this.list, iterable);
    }

    @Override
    public ListWrapper<T> copy() {
        List copy = ListWrapper.createList(this.list.getClass());
        ListWrapper.addToCollection(copy, this.list);
        return new ListWrapper<T>(this.list);
    }

    @Override
    public Dollar.Wrapper<T> shuffle(Random random) {
        Preconditions.require(random != null, "random must be non-null", new Object[0]);
        Collections.shuffle(this.list, random);
        return this;
    }

    @Override
    public Dollar.Wrapper<T> reverse() {
        Collections.reverse(this.list);
        return this;
    }

    @Override
    public Dollar.Wrapper<T> fill(T object) {
        Collections.fill(this.list, object);
        return this;
    }

    @Override
    public Dollar.Wrapper<T> slice(int i, int j) {
        if (i >= 0 && j < this.size()) {
            this.list = this.list.subList(i, j);
        }
        return this;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Dollar.Wrapper<T> sort() {
        Comparator comparator = Comparable.class.isInstance(this.list.get(0)) ? new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                Comparable c1 = (Comparable)o1;
                return c1.compareTo(o2);
            }
        } : new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return 0;
            }
        };
        return this.sort(comparator);
    }

    @Override
    public Dollar.Wrapper<T> sort(Comparator<T> comparator) {
        Collections.sort(this.list, comparator);
        return this;
    }

    @Override
    public ListWrapper<T> add(T item) {
        this.list.add(item);
        return this;
    }

    @Override
    public ListWrapper<T> addAll(Iterable<T> items) {
        ListWrapper.addToCollection(this.list, items);
        return this;
    }

    @Override
    public ListWrapper<T> threadSafe() {
        this.list = Collections.synchronizedList(this.list);
        return this;
    }

    @Override
    public ListWrapper<T> immutable() {
        List copy = ((AbstractWrapper)this.copy()).toList(this.list.getClass());
        this.list = Collections.unmodifiableList(copy);
        return this;
    }

    @Override
    public Dollar.ListWrapper<T> checked(Class<T> requiredClass) {
        this.list = Collections.checkedList(this.list, requiredClass);
        return this;
    }

    @Override
    public T[] toArray() {
        return ListWrapper.iterableToArray(this.list, this.list.size());
    }

    @Override
    public List<T> toList() {
        return this.list;
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    public boolean equals(Object object) {
        if (object instanceof ListWrapper) {
            ListWrapper listWrapper = (ListWrapper)object;
            return this.list.equals(listWrapper.list);
        }
        return false;
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    public String toString() {
        return this.list.toString();
    }
}

