/*
 * Decompiled with CFR 0.152.
 */
package com.humaorie.dollar;

import com.humaorie.dollar.AbstractWrapper;
import com.humaorie.dollar.Dollar;
import com.humaorie.dollar.Preconditions;
import com.humaorie.dollar.SortedMapWrapper;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class MapWrapper<K, V>
extends AbstractWrapper<K>
implements Dollar.MapWrapper<K, V> {
    private Map<K, V> map;

    public MapWrapper(Map<K, V> map) {
        Preconditions.require(map != null, "map must be non-null", new Object[0]);
        this.map = map;
    }

    @Override
    public MapWrapper<K, V> add(K key, V value) {
        this.map.put(key, value);
        return this;
    }

    @Override
    public MapWrapper<K, V> threadSafe() {
        this.map = Collections.synchronizedMap(this.map);
        return this;
    }

    @Override
    public MapWrapper<K, V> immutable() {
        this.map = Collections.unmodifiableMap(this.map);
        return this;
    }

    @Override
    public Dollar.MapWrapper<K, V> checked(Class<K> requiredKeyClass, Class<V> requiredValueClass) {
        this.map = Collections.checkedMap(this.map, requiredKeyClass, requiredValueClass);
        return this;
    }

    public MapWrapper<K, V> copy() {
        Map copy = (Map)MapWrapper.newInstanceOf(this.map.getClass());
        copy.putAll(this.map);
        return new MapWrapper<K, V>(copy);
    }

    @Override
    public Map<K, V> toMap() {
        return this.map;
    }

    @Override
    public Iterator<K> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public K[] toArray() {
        Set<K> keys = this.map.keySet();
        return MapWrapper.iterableToArray(keys, keys.size());
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Dollar.Wrapper<K> reverse() {
        return this;
    }

    @Override
    public Dollar.Wrapper<K> shuffle(Random random) {
        return this;
    }

    @Override
    public Dollar.Wrapper<K> sort() {
        return new SortedMapWrapper<K, V>(this.map);
    }

    public boolean equals(Object object) {
        if (object instanceof MapWrapper) {
            MapWrapper mapWrapper = (MapWrapper)object;
            return this.map.equals(mapWrapper.map);
        }
        return false;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }
}

