/*
 * Decompiled with CFR 0.152.
 */
package com.humaorie.dollar;

import com.humaorie.dollar.Dollar;
import com.humaorie.dollar.RandomIterator;
import com.humaorie.dollar.RandomWrapper;
import java.util.Iterator;
import java.util.Random;

class RandomIntegerWrapper
extends RandomWrapper<Integer> {
    private final int upTo;

    public RandomIntegerWrapper(Random random, int samples, int upTo) {
        super(random, samples);
        this.upTo = upTo;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new RandomIterator<Integer>(this.samples){

            @Override
            public Integer nextRandom() {
                return RandomIntegerWrapper.this.random.nextInt(RandomIntegerWrapper.this.upTo);
            }
        };
    }

    @Override
    public Dollar.Wrapper<Integer> copy() {
        return new RandomIntegerWrapper(this.random, this.samples, this.upTo);
    }

    public boolean equals(Object object) {
        if (object instanceof RandomIntegerWrapper) {
            RandomIntegerWrapper randomIntegerWrapper = (RandomIntegerWrapper)object;
            return this.random == randomIntegerWrapper.random && this.samples == randomIntegerWrapper.samples && this.upTo == randomIntegerWrapper.upTo;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash *= 79 + this.random.hashCode();
        hash *= 79 + this.upTo;
        return hash *= 79 + this.samples;
    }
}

