/*
 * Decompiled with CFR 0.152.
 */
package com.humaorie.dollar;

import com.humaorie.dollar.AbstractWrapper;
import com.humaorie.dollar.ArrayWrapper;
import com.humaorie.dollar.Dollar;
import com.humaorie.dollar.ListWrapper;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;

class RangeWrapper
extends AbstractWrapper<Integer> {
    private final int startFrom;
    private final int stopAt;
    private final int stepBy;

    public RangeWrapper(int stopAt) {
        if (stopAt < 0) {
            this.startFrom = stopAt;
            this.stopAt = 0;
            this.stepBy = 1;
        } else {
            this.startFrom = 0;
            this.stopAt = stopAt;
            this.stepBy = 1;
        }
    }

    public RangeWrapper(int startFrom, int stopAt) {
        if (startFrom > stopAt) {
            this.stepBy = -1;
            --stopAt;
            --startFrom;
        } else {
            this.stepBy = 1;
        }
        this.startFrom = startFrom;
        this.stopAt = stopAt;
    }

    public RangeWrapper(int startFrom, int stopAt, int stepBy) {
        if (startFrom > stopAt && stepBy > 0) {
            this.startFrom = 1;
            this.stopAt = 1;
            this.stepBy = 1;
        } else if (stopAt > startFrom && stepBy < 0) {
            this.startFrom = 1;
            this.stopAt = 1;
            this.stepBy = 1;
        } else if (stepBy == 0) {
            this.startFrom = 1;
            this.stopAt = 1;
            this.stepBy = 1;
        } else {
            this.startFrom = startFrom;
            this.stopAt = stopAt;
            this.stepBy = stepBy;
        }
    }

    @Override
    public Dollar.Wrapper<Integer> copy() {
        return new RangeWrapper(this.startFrom, this.stopAt, this.stepBy);
    }

    @Override
    public Dollar.Wrapper<Integer> reverse() {
        return new ListWrapper<Integer>(this).reverse();
    }

    @Override
    public Dollar.Wrapper<Integer> shuffle(Random random) {
        return new ArrayWrapper<Integer>(this.copy().toArray()).shuffle(random);
    }

    @Override
    public int size() {
        return Math.abs(this.startFrom - this.stopAt) / Math.abs(this.stepBy);
    }

    @Override
    public Dollar.Wrapper<Integer> sort() {
        if (this.stepBy > 0) {
            return this;
        }
        return new RangeWrapper(this.startFrom, this.stopAt, this.stepBy);
    }

    @Override
    public Iterator<Integer> iterator() {
        if (this.stepBy > 0) {
            return new RangeIterator();
        }
        return new ReversedRangeIterator();
    }

    public boolean equals(Object object) {
        if (object instanceof RangeWrapper) {
            RangeWrapper rangeWrapper = (RangeWrapper)object;
            return this.startFrom == rangeWrapper.startFrom && this.stopAt == rangeWrapper.stopAt && this.stepBy == rangeWrapper.stepBy;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash *= 19 + this.startFrom;
        hash *= 19 + this.stopAt;
        return hash *= 19 + this.stepBy;
    }

    class ReversedRangeIterator
    extends RangeIterator {
        ReversedRangeIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i > RangeWrapper.this.stopAt;
        }
    }

    class RangeIterator
    implements Iterator<Integer> {
        protected int i;

        public RangeIterator() {
            this.i = RangeWrapper.this.startFrom;
        }

        @Override
        public boolean hasNext() {
            return this.i < RangeWrapper.this.stopAt;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int tmp = this.i;
            this.i += RangeWrapper.this.stepBy;
            return tmp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported for RangeWrapper");
        }
    }
}

