/*
 * Decompiled with CFR 0.152.
 */
package com.humaorie.dollar;

import com.humaorie.dollar.AbstractWrapper;
import com.humaorie.dollar.CharSequenceWrapper;
import com.humaorie.dollar.Dollar;
import com.humaorie.dollar.Preconditions;
import java.util.Iterator;
import java.util.Random;

public class RepeatCharSequenceWrapper
extends AbstractWrapper<Character> {
    private final CharSequence charSequence;
    private final int count;

    public RepeatCharSequenceWrapper(CharSequence charSequence, int count) {
        this.charSequence = charSequence;
        this.count = count;
    }

    @Override
    public String join(String separator) {
        AbstractWrapper.Separator sep = new AbstractWrapper.Separator(separator);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.count; ++i) {
            sb.append(sep.toString());
            sb.append(this.charSequence);
        }
        return sb.toString();
    }

    private StringBuilder internalRepeat() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.count; ++i) {
            sb.append(this.charSequence);
        }
        return sb;
    }

    @Override
    public Iterator<Character> iterator() {
        return new CharSequenceWrapper.CharSequenceIterator(this.internalRepeat());
    }

    @Override
    public Dollar.Wrapper<Character> copy() {
        return new RepeatCharSequenceWrapper(this.charSequence, this.count);
    }

    @Override
    public int size() {
        return this.charSequence.length() * this.count;
    }

    @Override
    public Dollar.Wrapper<Character> reverse() {
        return new CharSequenceWrapper(this.internalRepeat()).reverse();
    }

    @Override
    public Dollar.Wrapper<Character> sort() {
        return new CharSequenceWrapper(this.internalRepeat()).sort();
    }

    @Override
    public Dollar.Wrapper<Character> shuffle(Random random) {
        Preconditions.require(random != null, "random must be non-null", new Object[0]);
        return new CharSequenceWrapper(this.internalRepeat()).shuffle(random);
    }

    public boolean equals(Object object) {
        if (object instanceof RepeatCharSequenceWrapper) {
            RepeatCharSequenceWrapper repeatCharSequenceWrapper = (RepeatCharSequenceWrapper)object;
            return this.charSequence.equals(repeatCharSequenceWrapper.charSequence) && this.count == repeatCharSequenceWrapper.count;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash *= 19 + this.charSequence.hashCode();
        return hash *= 19 + this.count;
    }
}

