/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.dbg.engine;

import com.sun.jdi.AbsentInformationException;
import cz.cuni.amis.pogamut.sposh.dbg.engine.EngineThread;
import java.lang.reflect.Method;
import java.util.List;
import java.util.NoSuchElementException;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;

public abstract class EvaluationListener
implements JPDABreakpointListener {
    public final String getDisplayName(JPDADebugger debugger, EngineThread thread) {
        String sessionName = EvaluationListener.getSession(debugger).getName();
        String engineName = thread.getName();
        return sessionName + '/' + engineName;
    }

    public final This getThisVariable(JPDAThread thread) throws AbsentInformationException {
        CallStackFrame frame = thread.getCallStack()[0];
        This thisVar = frame.getThisVariable();
        return thisVar;
    }

    public static Session getSession(JPDADebugger debugger) {
        Session[] sessions;
        assert (debugger != null);
        for (Session session : sessions = DebuggerManager.getDebuggerManager().getSessions()) {
            DebuggerEngine currentEngine = session.getCurrentEngine();
            if (currentEngine.lookup(null, JPDADebugger.class).contains(debugger)) {
                return session;
            }
            for (String lang : session.getSupportedLanguages()) {
                List sessionDebuggers = session.getEngineForLanguage(lang).lookup(null, JPDADebugger.class);
                if (!sessionDebuggers.contains(debugger)) continue;
                return session;
            }
        }
        throw new NoSuchElementException();
    }

    protected final void setCurrentThread(JPDADebugger dbg, JPDAThread thread) {
        try {
            Method m = dbg.getClass().getDeclaredMethod("setCurrentThreadNoFire", JPDAThread.class);
            boolean accessible = m.isAccessible();
            m.setAccessible(true);
            m.invoke((Object)dbg, thread);
            m.setAccessible(accessible);
        }
        catch (Exception ex) {
            throw new RuntimeException("Fail to invoke method", ex);
        }
    }

    protected final String callStringMethod(JPDADebugger debugger, This thisVar, JPDAThread thread, String methodName) throws NoSuchMethodException, InvalidExpressionException {
        String signature = "()Ljava/lang/String;";
        JPDAThread oldThread = debugger.getCurrentThread();
        this.setCurrentThread(debugger, thread);
        Variable res = thisVar.invokeMethod(methodName, signature, new Variable[0]);
        this.setCurrentThread(debugger, oldThread);
        String resultString = res.getValue();
        return resultString.substring(1, resultString.length() - 1);
    }

    protected final MethodBreakpoint createSelfRemoveBreakpoint(String stateClass, String methodName, int breakpointType) {
        final MethodBreakpoint bp = MethodBreakpoint.create();
        bp.setClassFilters(new String[]{stateClass});
        bp.setMethodName(methodName);
        bp.setHidden(false);
        bp.setBreakpointType(breakpointType);
        bp.addJPDABreakpointListener(new JPDABreakpointListener(){

            public void breakpointReached(JPDABreakpointEvent jpdabe) {
                bp.removeJPDABreakpointListener((JPDABreakpointListener)this);
                DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)bp);
            }
        });
        return bp;
    }
}

