/*
 * Decompiled with CFR 0.152.
 */
package math.bsp.strat;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import math.bsp.BspOccupation;
import math.bsp.SplitData;

public abstract class BspListDataStrategy<TElement, TBoundary> {
    public SplitData<ArrayList<TElement>> splitData(TBoundary boundary, ArrayList<TElement> data) {
        ArrayList positiveData = Lists.newArrayList();
        ArrayList negativeData = Lists.newArrayList();
        for (TElement element : data) {
            BspOccupation occupation = this.determineElementOccupation(boundary, element);
            if (occupation.intersectsPositive()) {
                positiveData.add(element);
            }
            if (!occupation.intersectsNegative()) continue;
            negativeData.add(element);
        }
        if (positiveData.isEmpty()) {
            positiveData = null;
        }
        if (negativeData.isEmpty()) {
            negativeData = null;
        }
        return new SplitData<ArrayList<TElement>>(negativeData, positiveData);
    }

    public static <TElement> ArrayList<TElement> joinData_static(ArrayList<TElement> data1, ArrayList<TElement> data2) {
        if (data1 == null && data2 == null) {
            return null;
        }
        HashSet joined = Sets.newHashSet();
        if (data1 != null) {
            joined.addAll(data1);
        }
        if (data2 != null) {
            joined.addAll(data2);
        }
        return new ArrayList(joined);
    }

    public ArrayList<TElement> joinData(ArrayList<TElement> data1, ArrayList<TElement> data2) {
        return BspListDataStrategy.joinData_static(data1, data2);
    }

    public static <TElement> ArrayList<TElement> removeData_static(ArrayList<TElement> data, ArrayList<TElement> dataToRemove) {
        if (data == null) {
            return null;
        }
        ArrayList pruned = Lists.newArrayList(data);
        if (dataToRemove != null) {
            pruned.removeAll(dataToRemove);
        }
        return pruned;
    }

    public ArrayList<TElement> removeData(ArrayList<TElement> data, ArrayList<TElement> dataToRemove) {
        return BspListDataStrategy.removeData_static(data, dataToRemove);
    }

    public abstract BspOccupation determineElementOccupation(TBoundary var1, TElement var2);
}

