/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import math.JavaGeomMath;
import math.geom2d.AffineTransform2D;
import math.geom2d.Angle2D;
import math.geom2d.Box2D;
import math.geom2d.Vector2D;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.CirculinearShape2D;
import math.geom2d.circulinear.GenericCirculinearDomain2D;
import math.geom2d.conic.Circle2D;
import math.geom2d.point.PointArray2D;
import math.geom2d.point.PointSet2D;
import math.geom2d.point.PointShape2D;
import math.geom2d.transform.CircleInversion2D;

public class Point2D
extends Point2D.Double
implements PointShape2D,
Cloneable,
CirculinearShape2D {
    private static final long serialVersionUID = 1L;
    @Deprecated
    public static final Point2D INFINITY_POINT = new Point2D(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

    public Point2D() {
        super(0.0, 0.0);
    }

    public Point2D(double x, double y) {
        super(x, y);
    }

    public Point2D(java.awt.geom.Point2D point) {
        super(point.getX(), point.getY());
    }

    @Deprecated
    public Point2D(java.awt.geom.Point2D point1, java.awt.geom.Point2D point2) {
        super(point1.getX() + point2.getX(), point1.getY() + point2.getY());
    }

    @Deprecated
    public Point2D(java.awt.geom.Point2D point1, double x, double y) {
        super(point1.getX() + x, point1.getY() + y);
    }

    public static final Point2D create(double x, double y) {
        return new Point2D(x, y);
    }

    public static final Point2D create(java.awt.geom.Point2D point) {
        return new Point2D(point.getX(), point.getY());
    }

    public static final Point2D createPolar(double rho, double theta) {
        return new Point2D(rho * Math.cos(theta), rho * Math.sin(theta));
    }

    public static final Point2D createPolar(Point2D point, double rho, double theta) {
        return new Point2D(point.getX() + rho * Math.cos(theta), point.getY() + rho * Math.sin(theta));
    }

    public static final Point2D createPolar(double x0, double y0, double rho, double theta) {
        return new Point2D(x0 + rho * Math.cos(theta), y0 + rho * Math.sin(theta));
    }

    public static final double getDistance(double x1, double y1, double x2, double y2) {
        return JavaGeomMath.hypot(x2 - x1, y2 - y1);
    }

    public static final double getDistance(java.awt.geom.Point2D p1, java.awt.geom.Point2D p2) {
        return JavaGeomMath.hypot(p1.getX() - p2.getX(), p1.getY() - p2.getY());
    }

    public static final boolean isColinear(java.awt.geom.Point2D p1, java.awt.geom.Point2D p2, java.awt.geom.Point2D p3) {
        double dx1 = p2.getX() - p1.getX();
        double dy1 = p2.getY() - p1.getY();
        double dx2 = p3.getX() - p1.getX();
        double dy2 = p3.getY() - p1.getY();
        return Math.abs(dx1 * dy2 - dy1 * dx2) < 1.0E-12;
    }

    public static final int ccw(Point2D p0, Point2D p1, Point2D p2) {
        double x0 = p0.getX();
        double y0 = p0.getY();
        double dx1 = p1.getX() - x0;
        double dy1 = p1.getY() - y0;
        double dx2 = p2.getX() - x0;
        double dy2 = p2.getY() - y0;
        if (dx1 * dy2 > dy1 * dx2) {
            return 1;
        }
        if (dx1 * dy2 < dy1 * dx2) {
            return -1;
        }
        if (dx1 * dx2 < 0.0 || dy1 * dy2 < 0.0) {
            return -1;
        }
        if (dx1 * dx1 + dy1 * dy1 < dx2 * dx2 + dy2 * dy2) {
            return 1;
        }
        return 0;
    }

    public static final Point2D midPoint(java.awt.geom.Point2D p1, java.awt.geom.Point2D p2) {
        return new Point2D((p1.getX() + p2.getX()) / 2.0, (p1.getY() + p2.getY()) / 2.0);
    }

    public static final Point2D centroid(java.awt.geom.Point2D[] points) {
        int n = points.length;
        double sx = 0.0;
        double sy = 0.0;
        for (int i = 0; i < n; ++i) {
            sx += points[i].getX();
            sy += points[i].getY();
        }
        return new Point2D(sx / (double)n, sy / (double)n);
    }

    public static final Point2D centroid(java.awt.geom.Point2D[] points, double[] weights) {
        int n = points.length;
        if (n != weights.length) {
            throw new RuntimeException("Arrays must have the same size");
        }
        double sx = 0.0;
        double sy = 0.0;
        double sw = 0.0;
        for (int i = 0; i < n; ++i) {
            double w = weights[i];
            sx += points[i].getX() * w;
            sy += points[i].getY() * w;
            sw += w;
        }
        return new Point2D(sx / sw, sy / sw);
    }

    public static final Point2D centroid(Collection<? extends Point2D> points) {
        int n = points.size();
        double sx = 0.0;
        double sy = 0.0;
        for (Point2D point2D : points) {
            sx += point2D.getX();
            sy += point2D.getY();
        }
        return new Point2D(sx / (double)n, sy / (double)n);
    }

    public static final Point2D centroid(java.awt.geom.Point2D pt1, java.awt.geom.Point2D pt2, java.awt.geom.Point2D pt3) {
        return new Point2D((pt1.getX() + pt2.getX() + pt3.getX()) / 3.0, (pt1.getY() + pt2.getY() + pt3.getY()) / 3.0);
    }

    public Point2D plus(java.awt.geom.Point2D p) {
        return new Point2D(p.getX() + this.x, p.getY() + this.y);
    }

    public Point2D plus(Vector2D v) {
        return this.plus(v.asPoint2D());
    }

    public Point2D minus(java.awt.geom.Point2D p) {
        return new Point2D(this.x - p.getX(), this.y - p.getY());
    }

    public Point2D minus(Vector2D v) {
        return this.minus(v.asPoint2D());
    }

    public Point2D translate(double tx, double ty) {
        return new Point2D(this.x + tx, this.y + ty);
    }

    public Point2D scale(double kx, double ky) {
        return new Point2D(this.x * kx, this.y * ky);
    }

    public Point2D scale(double k) {
        return new Point2D(this.x * k, this.y * k);
    }

    public Point2D rotate(double theta) {
        double cot = Math.cos(theta);
        double sit = Math.sin(theta);
        return new Point2D(this.x * cot - this.y * sit, this.x * sit + this.y * cot);
    }

    public Point2D rotate(Point2D center, double theta) {
        double cx = center.getX();
        double cy = center.getY();
        double cot = Math.cos(theta);
        double sit = Math.sin(theta);
        return new Point2D(this.x * cot - this.y * sit + (1.0 - cot) * cx + sit * cy, this.x * sit + this.y * cot + (1.0 - cot) * cy - sit * cx);
    }

    public Point getAsInt() {
        return new Point((int)this.x, (int)this.y);
    }

    public Point2D.Double getAsDouble() {
        return new Point2D.Double(this.x, this.y);
    }

    public Point2D.Float getAsFloat() {
        return new Point2D.Float((float)this.x, (float)this.y);
    }

    @Deprecated
    public void setPolarLocation(double rho, double theta) {
        this.x = rho * Math.cos(theta);
        this.y = rho * Math.sin(theta);
    }

    @Deprecated
    public void setPolarLocation(java.awt.geom.Point2D point, double rho, double theta) {
        this.x = point.getX() + rho * Math.cos(theta);
        this.y = point.getY() + rho * Math.sin(theta);
    }

    @Override
    public CirculinearDomain2D getBuffer(double dist) {
        return new GenericCirculinearDomain2D(new Circle2D(this, Math.abs(dist), dist > 0.0));
    }

    @Override
    public Point2D transform(CircleInversion2D inv) {
        Point2D center = inv.getCenter();
        double r = inv.getRadius();
        double d = r * r / Point2D.getDistance(this, center);
        double theta = Angle2D.getHorizontalAngle(center, this);
        return Point2D.createPolar(center, d, theta);
    }

    @Override
    public double getDistance(java.awt.geom.Point2D point) {
        return this.getDistance(point.getX(), point.getY());
    }

    @Override
    public double getDistance(double x, double y) {
        return JavaGeomMath.hypot(this.getX() - x, this.getY() - y);
    }

    @Override
    public boolean isBounded() {
        if (Double.isInfinite(this.x)) {
            return false;
        }
        if (Double.isInfinite(this.y)) {
            return false;
        }
        if (Double.isNaN(this.x)) {
            return false;
        }
        return !Double.isNaN(this.y);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(double x, double y) {
        return this.equals(new Point2D(x, y));
    }

    @Override
    public boolean contains(java.awt.geom.Point2D p) {
        return this.equals(p);
    }

    @Override
    public PointSet2D clip(Box2D box) {
        PointArray2D set = new PointArray2D(0);
        if (this.x < box.getMinX()) {
            return set;
        }
        if (this.y < box.getMinY()) {
            return set;
        }
        if (this.x > box.getMaxX()) {
            return set;
        }
        if (this.y > box.getMaxY()) {
            return set;
        }
        set.addPoint(this);
        return set;
    }

    @Override
    public Box2D getBoundingBox() {
        return new Box2D(this.getX(), this.getX(), this.getY(), this.getY());
    }

    @Override
    public Point2D transform(AffineTransform2D trans) {
        double[] tab = trans.getCoefficients();
        return new Point2D(this.x * tab[0] + this.y * tab[1] + tab[2], this.x * tab[3] + this.y * tab[4] + tab[5]);
    }

    @Override
    public void draw(Graphics2D g2) {
        this.draw(g2, 1.0);
    }

    public void draw(Graphics2D g2, double r) {
        g2.fill(new Ellipse2D.Double(this.x - r, this.y - r, 2.0 * r, 2.0 * r));
    }

    @Override
    public int getPointNumber() {
        return 1;
    }

    @Override
    public Collection<Point2D> getPoints() {
        ArrayList<Point2D> array = new ArrayList<Point2D>(1);
        array.add(this);
        return array;
    }

    @Override
    public Iterator<Point2D> iterator() {
        return this.getPoints().iterator();
    }

    @Override
    public String toString() {
        return new String("Point2D(" + this.x + ", " + this.y + ")");
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof java.awt.geom.Point2D)) {
            return false;
        }
        java.awt.geom.Point2D p = (java.awt.geom.Point2D)obj;
        return this.distance(p.getX(), p.getY()) < 1.0E-12;
    }

    @Override
    public Point2D clone() {
        return new Point2D(this.x, this.y);
    }

    public Vector2D asVector2D() {
        return new Vector2D(this.x, this.y);
    }
}

