/*
 * Decompiled with CFR 0.152.
 */
package math.geom3d;

import java.io.Serializable;
import math.geom3d.Box3D;
import math.geom3d.Point3D;
import math.geom3d.transform.AffineTransform3D;

public interface Shape3D
extends Serializable {
    public static final double ACCURACY = 1.0E-12;
    public static final double ACCURACY_INVERSE = 1.0E12;
    public static final Shape3D EMPTY_SET = new EmptySet3D();

    public boolean isEmpty();

    public boolean isBounded();

    public Box3D getBoundingBox();

    public Shape3D clip(Box3D var1);

    public Shape3D transform(AffineTransform3D var1);

    public double getDistance(Point3D var1);

    public boolean contains(Point3D var1);

    public static class EmptySet3D
    implements Shape3D {
        protected EmptySet3D() {
        }

        @Override
        public double getDistance(Point3D p) {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean isBounded() {
            return false;
        }

        @Override
        public boolean contains(Point3D point) {
            return false;
        }

        @Override
        public Box3D getBoundingBox() {
            return new Box3D(Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        }

        @Override
        public Shape3D clip(Box3D box) {
            return this;
        }

        @Override
        public Shape3D transform(AffineTransform3D trans) {
            return this;
        }
    }
}

