/*
 * Decompiled with CFR 0.152.
 */
package math.geom3d.line;

import java.util.ArrayList;
import java.util.Collection;
import math.JavaGeomMath;
import math.geom3d.Box3D;
import math.geom3d.Point3D;
import math.geom3d.Shape3D;
import math.geom3d.Vector3D;
import math.geom3d.curve.ContinuousCurve3D;
import math.geom3d.curve.Curve3D;
import math.geom3d.plane.Plane3D;
import math.geom3d.transform.AffineTransform3D;

public class StraightLine3D
implements ContinuousCurve3D {
    private static final long serialVersionUID = 1L;
    protected Point3D origin;
    protected Vector3D vector;
    protected transient Vector3D vectorInverse = null;

    public StraightLine3D() {
        this.origin = new Point3D(0.0, 0.0, 0.0);
        this.vector = new Vector3D(1.0, 0.0, 0.0);
    }

    public StraightLine3D(Point3D origin, Vector3D vector) {
        this.origin = origin;
        this.vector = vector;
    }

    public StraightLine3D(Point3D p1, Point3D p2) {
        this(p1, new Vector3D(p1, p2));
    }

    public StraightLine3D(double x0, double y0, double z0, double dx, double dy, double dz) {
        this.origin = new Point3D(x0, y0, z0);
        this.vector = new Vector3D(dx, dy, dz);
    }

    public Point3D getOrigin() {
        return this.origin;
    }

    public Point3D getExamplePoint1() {
        return this.getOrigin();
    }

    public Point3D getExamplePoint2() {
        return this.origin.plus(this.vector);
    }

    public Vector3D getVector() {
        return this.vector;
    }

    public Vector3D getVectorInverse() {
        if (this.vectorInverse == null) {
            this.vectorInverse = new Vector3D(1.0 / this.vector.getX(), 1.0 / this.vector.getY(), 1.0 / this.vector.getZ());
        }
        return this.vectorInverse;
    }

    public StraightLine3D project(Plane3D plane) {
        return new StraightLine3D(plane.project(this.getExamplePoint1()), plane.project(this.getExamplePoint2()));
    }

    public Point3D projectPoint(Point3D point) {
        return this.getPoint(this.project(point));
    }

    @Override
    public Shape3D clip(Box3D box) {
        return null;
    }

    @Override
    public boolean contains(Point3D point) {
        return this.getDistance(point) < 1.0E-12;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isBounded() {
        return false;
    }

    @Override
    public Box3D getBoundingBox() {
        Vector3D v = this.getVector();
        if (JavaGeomMath.hypot(v.getY(), v.getZ()) < 1.0E-12) {
            return new Box3D(this.origin.getX(), this.origin.getX(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        if (JavaGeomMath.hypot(v.getX(), v.getZ()) < 1.0E-12) {
            return new Box3D(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, this.origin.getY(), this.origin.getY(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        if (JavaGeomMath.hypot(v.getX(), v.getY()) < 1.0E-12) {
            return new Box3D(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, this.origin.getZ(), this.origin.getZ());
        }
        return new Box3D(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public double getDistance(Point3D p) {
        Vector3D vl = this.getVector();
        Vector3D vp = new Vector3D(this.getOrigin(), p);
        return Vector3D.crossProduct(vl, vp).getNorm() / vl.getNorm();
    }

    @Override
    public StraightLine3D transform(AffineTransform3D trans) {
        return new StraightLine3D(this.getOrigin().transform(trans), this.getVector().transform(trans));
    }

    @Override
    public Point3D getFirstPoint() {
        return new Point3D(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public Point3D getLastPoint() {
        return new Point3D(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public Point3D getPoint(double t) {
        return new Point3D(this.origin.getX() + t * this.vector.getX(), this.origin.getY() + t * this.vector.getY(), this.origin.getZ() + t * this.vector.getZ());
    }

    @Override
    @Deprecated
    public Point3D getPoint(double t, Point3D point) {
        if (point == null) {
            point = new Point3D();
        }
        point.setX(this.origin.getX() + t * this.vector.getX());
        point.setY(this.origin.getY() + t * this.vector.getY());
        point.setZ(this.origin.getZ() + t * this.vector.getZ());
        return point;
    }

    @Override
    public double getPosition(Point3D point) {
        return this.project(point);
    }

    @Override
    public StraightLine3D getReverseCurve() {
        return new StraightLine3D(this.getOrigin(), this.getVector().getOpposite());
    }

    @Override
    public Collection<Point3D> getSingularPoints() {
        return new ArrayList<Point3D>(0);
    }

    @Override
    public Curve3D getSubCurve(double t0, double t1) {
        return null;
    }

    @Override
    public double getT0() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getT1() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double project(Point3D point) {
        Vector3D vl = this.getVector();
        Vector3D vp = new Vector3D(this.getOrigin(), point);
        return Vector3D.dotProduct(vl, vp) / vl.getNormSq();
    }

    public double getPlaneIntersectionParametric(Plane3D plane) {
        Vector3D planeNormal = plane.getNormalVector();
        double normalLineDot = Vector3D.dotProduct(planeNormal, this.getVector());
        if (Math.abs(normalLineDot) < 1.0E-12) {
            return Double.NaN;
        }
        Vector3D dp = new Vector3D(this.getOrigin(), plane.getOrigin());
        return Vector3D.dotProduct(planeNormal, dp) / normalLineDot;
    }

    public Point3D getPlaneIntersection(Plane3D plane) {
        double t = this.getPlaneIntersectionParametric(plane);
        if (!Double.isInfinite(t) && !Double.isNaN(t)) {
            return this.getPoint(t);
        }
        return null;
    }

    public Collection<StraightLine3D> getContinuousCurves() {
        ArrayList<StraightLine3D> array = new ArrayList<StraightLine3D>(1);
        array.add(this);
        return array;
    }
}

