/*
 * Decompiled with CFR 0.152.
 */
package math.geom3d.plane;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import math.geom3d.Box3D;
import math.geom3d.Point3D;
import math.geom3d.Shape3D;
import math.geom3d.Vector3D;
import math.geom3d.plane.Plane3DCoordinateSubsystem;
import math.geom3d.transform.AffineTransform3D;

public class Plane3D
implements Shape3D {
    private static final long serialVersionUID = 1L;
    protected Point3D origin;
    protected Vector3D vector1;
    protected Vector3D vector2;
    protected transient Plane3DCoordinateSubsystem coordinateSubsystem = null;
    protected transient Vector3D normal = null;
    public static final Plane3D xyPlane = new Plane3D(new Point3D(0.0, 0.0, 0.0), new Vector3D(0.0, 1.0, 0.0), new Vector3D(1.0, 0.0, 0.0));
    public static final Plane3D xzPlane = new Plane3D(new Point3D(0.0, 0.0, 0.0), new Vector3D(1.0, 0.0, 0.0), new Vector3D(0.0, 0.0, 1.0));
    public static final Plane3D yzPlane = new Plane3D(new Point3D(0.0, 0.0, 0.0), new Vector3D(0.0, 0.0, 1.0), new Vector3D(0.0, 1.0, 0.0));

    public static Plane3D createPlaneDefinedByPoints(Collection<Point3D> pointsInPlane) {
        Point3D[] anchors = Plane3D.pickAnchors(pointsInPlane);
        return new Plane3D(anchors[0], new Vector3D(anchors[0], anchors[1]), new Vector3D(anchors[0], anchors[2]));
    }

    public Plane3D(Point3D origin, Vector3D vector1, Vector3D vector2) {
        this.origin = origin;
        this.vector1 = vector1;
        this.vector2 = vector2;
    }

    public Point3D getOrigin() {
        return this.origin;
    }

    public Vector3D getVector1() {
        return this.vector1;
    }

    public Vector3D getVector2() {
        return this.vector2;
    }

    public Vector3D getNormalVector() {
        if (this.normal == null) {
            this.normal = Vector3D.crossProduct(this.vector1, this.vector2).getOpposite().getNormalizedVector();
        }
        return this.normal;
    }

    public Point3D project(Point3D point) {
        Vector3D planeNormal = this.getNormalVector();
        Vector3D dp = new Vector3D(point, this.getOrigin());
        double t = Vector3D.dotProduct(planeNormal, dp);
        return new Point3D(point.getX() + t * planeNormal.getX(), point.getY() + t * planeNormal.getY(), point.getZ() + t * planeNormal.getZ());
    }

    public Vector3D project(Vector3D vector) {
        return new Vector3D(this.project(new Point3D(vector)));
    }

    public Plane3DCoordinateSubsystem getCoordinateSubsystem() {
        if (this.coordinateSubsystem == null) {
            this.coordinateSubsystem = new Plane3DCoordinateSubsystem(this);
        }
        return this.coordinateSubsystem;
    }

    @Override
    public Shape3D clip(Box3D box) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Point3D point) {
        Point3D proj = this.project(point);
        return point.getDistanceSquare(proj) < 1.0E-24;
    }

    @Override
    public Box3D getBoundingBox() {
        if (Math.abs(this.vector1.getZ()) < 1.0E-12 && Math.abs(this.vector2.getZ()) < 1.0E-12) {
            return new Box3D(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, this.origin.getZ(), this.origin.getZ());
        }
        if (Math.abs(this.vector1.getX()) < 1.0E-12 && Math.abs(this.vector2.getX()) < 1.0E-12) {
            return new Box3D(this.origin.getX(), this.origin.getX(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        if (Math.abs(this.vector1.getY()) < 1.0E-12 && Math.abs(this.vector2.getY()) < 1.0E-12) {
            return new Box3D(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, this.origin.getY(), this.origin.getY(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        return new Box3D(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public double getSignedDistance(Point3D point) {
        Point3D projectedPoint = this.project(point);
        Vector3D pointOffset = new Vector3D(projectedPoint, point);
        double dotProduct = Vector3D.dotProduct(this.getNormalVector(), pointOffset);
        return point.getDistance(projectedPoint) * Math.signum(dotProduct);
    }

    @Override
    public double getDistance(Point3D point) {
        return point.getDistance(this.project(point));
    }

    @Override
    public boolean isBounded() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Shape3D transform(AffineTransform3D trans) {
        return new Plane3D(this.getOrigin().transform(trans), this.getVector1().transform(trans), this.getVector2().transform(trans));
    }

    public boolean equals(Object obj) {
        if (obj instanceof Plane3D) {
            Plane3D plane = (Plane3D)obj;
            return this.origin.equals(plane.origin) && this.vector1.equals(plane.vector1) && this.vector2.equals(plane.vector2);
        }
        return false;
    }

    public String toString() {
        return "Plane3D( origin: " + this.origin + ", vector1: " + this.vector1 + " vector2: " + this.vector2 + ")";
    }

    public static Point3D[] pickAnchors(Collection<Point3D> pointsInPlane) {
        if (pointsInPlane.size() == 3) {
            return pointsInPlane.toArray(new Point3D[3]);
        }
        ArrayList<Point3D> points = new ArrayList<Point3D>(pointsInPlane);
        final Point3D a = points.remove(0);
        Collections.sort(points, new Comparator<Point3D>(){

            @Override
            public int compare(Point3D lhs, Point3D rhs) {
                return Double.compare(a.getDistanceSquare(lhs), a.getDistanceSquare(rhs));
            }
        });
        final Point3D b = points.remove(points.size() - 1);
        Collections.sort(points, new Comparator<Point3D>(){

            @Override
            public int compare(Point3D lhs, Point3D rhs) {
                return Double.compare(Plane3D.rateAnchors(a, b, lhs), Plane3D.rateAnchors(a, b, rhs));
            }
        });
        Point3D c = points.remove(points.size() - 1);
        return new Point3D[]{a, b, c};
    }

    protected static double rateAnchors(Point3D a, Point3D b, Point3D c) {
        Vector3D ab = new Vector3D(a, b);
        Vector3D ac = new Vector3D(a, c);
        Vector3D abn = ab.getNormalizedVector();
        Vector3D acn = ac.getNormalizedVector();
        double linearIndependencyFactor = Math.min(abn.minus(acn).getLength(), abn.plus(acn).getLength());
        double distanceFactor = Math.min(ab.getLength(), ac.getLength());
        return distanceFactor * linearIndependencyFactor;
    }
}

