/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.worldview.react;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;

public abstract class ObjectEventReact<OBJECT extends IWorldObject, EVENT extends IWorldObjectEvent<OBJECT>> {
    protected static final int LEVEL_B_EVENT = 1;
    protected static final int LEVEL_C_EVENT = 2;
    protected static final int LEVEL_D_EVENT = 3;
    protected static final int LEVEL_E_EVENT = 4;
    protected IWorldObjectEventListener<OBJECT, EVENT> reactListener = new IWorldObjectEventListener<OBJECT, EVENT>(){

        public void notify(EVENT event) {
            ObjectEventReact.this.preReact(event);
            ObjectEventReact.this.react(event);
            ObjectEventReact.this.postReact(event);
        }
    };
    protected IWorldView reactWorldView;
    protected Class reactEventClass;
    protected Class reactObjectClass;
    protected WorldObjectId reactObjectId;
    protected final int reactObjectEventType;
    private boolean reactHooked = false;

    public ObjectEventReact(Class<?> objectClass, IWorldView worldView) {
        this.reactWorldView = worldView;
        this.reactObjectClass = objectClass;
        this.reactObjectEventType = 1;
        this.enable();
    }

    public ObjectEventReact(Class<?> objectClass, Class<?> eventClass, IWorldView worldView) {
        this.reactWorldView = worldView;
        this.reactObjectClass = objectClass;
        this.reactEventClass = eventClass;
        this.reactObjectEventType = 2;
        this.enable();
    }

    public ObjectEventReact(WorldObjectId objectId, IWorldView worldView) {
        this.reactWorldView = worldView;
        this.reactObjectId = objectId;
        this.reactObjectEventType = 3;
        this.enable();
    }

    public ObjectEventReact(WorldObjectId objectId, Class<?> eventClass, IWorldView worldView) {
        this.reactWorldView = worldView;
        this.reactObjectId = objectId;
        this.reactEventClass = eventClass;
        this.reactObjectEventType = 4;
        this.enable();
    }

    public synchronized void disable() {
        if (this.reactHooked) {
            this.reactHooked = false;
            switch (this.reactObjectEventType) {
                case 1: {
                    this.reactWorldView.removeObjectListener(this.reactObjectClass, this.reactListener);
                    break;
                }
                case 2: {
                    this.reactWorldView.removeObjectListener(this.reactObjectClass, this.reactEventClass, this.reactListener);
                    break;
                }
                case 3: {
                    this.reactWorldView.removeObjectListener(this.reactObjectId, this.reactListener);
                    break;
                }
                case 4: {
                    this.reactWorldView.removeObjectListener(this.reactObjectId, this.reactEventClass, this.reactListener);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled objectEventType = " + this.reactObjectEventType + ".");
                }
            }
        }
    }

    public synchronized void enable() {
        if (!this.reactHooked) {
            this.reactHooked = true;
            switch (this.reactObjectEventType) {
                case 1: {
                    if (this.reactWorldView.isListening(this.reactEventClass, this.reactListener)) break;
                    this.reactWorldView.addObjectListener(this.reactObjectClass, this.reactListener);
                    break;
                }
                case 2: {
                    if (this.reactWorldView.isListening(this.reactObjectClass, this.reactListener)) break;
                    this.reactWorldView.addObjectListener(this.reactObjectClass, this.reactEventClass, this.reactListener);
                    break;
                }
                case 3: {
                    if (this.reactWorldView.isListening(this.reactObjectId, this.reactListener)) break;
                    this.reactWorldView.addObjectListener(this.reactObjectId, this.reactListener);
                    break;
                }
                case 4: {
                    if (this.reactWorldView.isListening(this.reactObjectId, this.reactEventClass, this.reactListener)) break;
                    this.reactWorldView.addObjectListener(this.reactObjectId, this.reactEventClass, this.reactListener);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled objectEventType = " + this.reactObjectEventType + ".");
                }
            }
        }
    }

    protected void preReact(EVENT event) {
    }

    protected abstract void react(EVENT var1);

    protected void postReact(EVENT event) {
    }
}

