/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.component.controller;

import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.controller.ComponentState;
import cz.cuni.amis.pogamut.base.component.controller.IComponentControlHelper;
import cz.cuni.amis.pogamut.base.component.controller.IComponentControllerBase;
import cz.cuni.amis.pogamut.base.component.exception.ComponentKilledException;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import cz.cuni.amis.utils.flag.WaitForFlagChange;
import cz.cuni.amis.utils.token.IToken;
import cz.cuni.amis.utils.token.Tokens;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractComponentControllerBase<COMPONENT extends IComponent>
implements IComponentControllerBase<COMPONENT> {
    protected IToken controllerId;
    protected IComponentControlHelper control;
    protected COMPONENT component;
    protected Logger log;
    protected Flag<ComponentState> componentState = new Flag((Object)ComponentState.INSTANTIATED);
    protected boolean broadcastingEvents = true;

    public AbstractComponentControllerBase(COMPONENT component, IComponentControlHelper componentControlHelper, Logger log) {
        this.log = log;
        NullCheck.check((Object)this.log, (String)"log");
        this.component = component;
        NullCheck.check(this.component, (String)"component");
        this.control = componentControlHelper;
        NullCheck.check((Object)this.control, (String)"componentControlHelper");
        this.controllerId = Tokens.get((String)(component.getComponentId().getToken() + "-controller"));
    }

    public AbstractComponentControllerBase(IToken componentControllerId, COMPONENT component, IComponentControlHelper componentControlHelper, Logger log) {
        this(component, componentControlHelper, log);
        this.controllerId = componentControllerId;
        NullCheck.check((Object)this.controllerId, (String)"componentControllerId");
    }

    public String toString() {
        if (this == null) {
            return "AbstractComponentControllerBase";
        }
        if (this.getComponentId() == null) {
            return this.getClass().getSimpleName();
        }
        return this.getClass().getSimpleName() + "[" + this.getComponentId().getToken() + "]";
    }

    @Override
    public IToken getComponentId() {
        return this.controllerId;
    }

    public Logger getLog() {
        return this.log;
    }

    @Override
    public COMPONENT getComponent() {
        return this.component;
    }

    @Override
    public boolean isBroadcastingEvents() {
        return this.broadcastingEvents;
    }

    @Override
    public void setBroadcastingEvents(boolean broadcastingEvents) {
        this.broadcastingEvents = broadcastingEvents;
    }

    @Override
    public IComponentControlHelper getComponentControl() {
        return this.control;
    }

    @Override
    public boolean isRunning() {
        return this.inState(ComponentState.PAUSING, ComponentState.PAUSED, ComponentState.RESUMING, ComponentState.RUNNING);
    }

    @Override
    public boolean isPaused() {
        return this.inState(ComponentState.STARTING_PAUSED, ComponentState.PAUSED, ComponentState.PAUSING, ComponentState.RESUMING);
    }

    @Override
    public ImmutableFlag<ComponentState> getState() {
        return this.componentState.getImmutable();
    }

    @Override
    public boolean inState(ComponentState ... states) {
        return ComponentState.inside((ComponentState)((Object)this.componentState.getFlag()), states);
    }

    @Override
    public boolean notInState(ComponentState ... states) {
        return ComponentState.notInside((ComponentState)((Object)this.componentState.getFlag()), states);
    }

    @Override
    public ComponentState awaitState(ComponentState ... states) throws ComponentKilledException {
        ComponentState resultState = (ComponentState)((Object)new WaitForFlagChange(this.componentState, (WaitForFlagChange.IAccept)new AwaitState(states)).await());
        if (ComponentState.inside(resultState, ComponentState.KILLING, ComponentState.KILLED) && !ComponentState.partOf(states, ComponentState.KILLING, ComponentState.KILLED)) {
            throw new ComponentKilledException((IComponent)this.component, (Object)this);
        }
        return resultState;
    }

    @Override
    public ComponentState awaitState(long timeoutMillis, ComponentState ... states) throws ComponentKilledException {
        ComponentState resultState = (ComponentState)((Object)new WaitForFlagChange(this.componentState, (WaitForFlagChange.IAccept)new AwaitState(states)).await(timeoutMillis, TimeUnit.MILLISECONDS));
        if (ComponentState.inside(resultState, ComponentState.KILLING, ComponentState.KILLED) && !ComponentState.partOf(states, ComponentState.KILLING, ComponentState.KILLED)) {
            throw new ComponentKilledException((IComponent)this.component, (Object)this);
        }
        return resultState;
    }

    protected String id(IComponent component) {
        if (component == null) {
            return "null";
        }
        return component.getComponentId().getToken();
    }

    protected void setState(ComponentState state) {
        if (state == this.componentState.getFlag()) {
            return;
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Switching to " + (Object)((Object)state) + ".");
        }
        this.componentState.setFlag((Object)state);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("In state " + (Object)((Object)state) + ".");
        }
    }

    protected static class AwaitState
    implements WaitForFlagChange.IAccept<ComponentState> {
        Set<ComponentState> awaiting = new HashSet<ComponentState>();

        public AwaitState(ComponentState ... states) {
            for (ComponentState state : states) {
                this.awaiting.add(state);
            }
        }

        public boolean accept(ComponentState flagValue) {
            return this.awaiting.contains((Object)flagValue);
        }
    }
}

