/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.worldview.impl;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.controller.ComponentControlHelper;
import cz.cuni.amis.pogamut.base.component.controller.ComponentController;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.IComponentControlHelper;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.utils.ClassUtils;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.listener.IListener;
import cz.cuni.amis.utils.listener.Listeners;
import cz.cuni.amis.utils.listener.ListenersMap;
import cz.cuni.amis.utils.maps.HashMapMap;
import cz.cuni.amis.utils.maps.LazyMap;
import cz.cuni.amis.utils.token.Token;
import cz.cuni.amis.utils.token.Tokens;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

@AgentScoped
public abstract class AbstractWorldView
implements IWorldView {
    public static final Token COMPONENT_ID = Tokens.get((String)"WorldView");
    private ListenerNotifier notifier = new ListenerNotifier();
    private HashMapMap<Class, WorldObjectId, IWorldObject> worldObjects = new HashMapMap();
    private Map<Class, Map<WorldObjectId, IWorldObject>> syncWorldObjects = Collections.synchronizedMap(this.worldObjects);
    private Map<WorldObjectId, IWorldObject> knownObjects = Collections.synchronizedMap(new HashMap());
    private ListenersMap<Class> eventListeners = new ListenersMap();
    private ListenersMap<Class> objectsListeners = new ListenersMap();
    private Map<Class, ListenersMap<Class>> objectEventListeners = Collections.synchronizedMap(new LazyMap<Class, ListenersMap<Class>>(){

        protected ListenersMap<Class> create(Class key) {
            return new ListenersMap();
        }
    });
    private ListenersMap<WorldObjectId> specificObjectListeners = new ListenersMap();
    private Map<WorldObjectId, ListenersMap<Class>> specificObjectEventListeners = Collections.synchronizedMap(new LazyMap<WorldObjectId, ListenersMap<Class>>(){

        protected ListenersMap<Class> create(WorldObjectId key) {
            return new ListenersMap();
        }
    });
    private boolean raiseEventProcessing = false;
    private Queue<IWorldEvent> raiseEventsList = new ConcurrentLinkedQueue<IWorldEvent>();
    protected LogCategory log;
    protected IComponentBus eventBus;
    protected ComponentController<IComponent> controller;
    protected IComponentControlHelper control = new ComponentControlHelper(){

        @Override
        public void startPaused() {
            AbstractWorldView.this.start(true);
        }

        @Override
        public void start() throws PogamutException {
            AbstractWorldView.this.start(false);
        }

        @Override
        public void prePause() throws PogamutException {
            AbstractWorldView.this.prePause();
        }

        @Override
        public void pause() throws PogamutException {
            AbstractWorldView.this.pause();
        }

        @Override
        public void resume() throws PogamutException {
            AbstractWorldView.this.resume();
        }

        @Override
        public void preStop() throws PogamutException {
            AbstractWorldView.this.preStop();
        }

        @Override
        public void stop() throws PogamutException {
            AbstractWorldView.this.stop();
        }

        @Override
        public void kill() {
            AbstractWorldView.this.kill();
        }

        @Override
        public void reset() {
            AbstractWorldView.this.reset();
        }
    };

    public AbstractWorldView(ComponentDependencies dependencies, IComponentBus bus, IAgentLogger logger) {
        this.log = logger.getCategory(this.getComponentId().getToken());
        this.eventBus = bus;
        this.controller = new ComponentController<AbstractWorldView>(this, this.control, this.eventBus, (Logger)this.log, dependencies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUp() {
        Object object = this.worldObjects;
        synchronized (object) {
            this.worldObjects.clear();
        }
        object = this.knownObjects;
        synchronized (object) {
            this.knownObjects.clear();
        }
        object = this.raiseEventsList;
        synchronized (object) {
            this.raiseEventsList.clear();
        }
    }

    protected void start(boolean startPaused) {
        this.cleanUp();
    }

    protected void prePause() {
    }

    protected void pause() {
    }

    protected void resume() {
    }

    protected void preStop() {
    }

    protected void stop() {
        this.cleanUp();
    }

    protected void kill() {
        this.cleanUp();
    }

    protected void reset() {
        this.cleanUp();
    }

    protected boolean isRunning() {
        return this.controller.isRunning();
    }

    protected boolean isPaused() {
        return this.controller.isPaused();
    }

    public Token getComponentId() {
        return COMPONENT_ID;
    }

    public LogCategory getLog() {
        return this.log;
    }

    @Override
    public IComponentBus getEventBus() {
        return this.eventBus;
    }

    @Override
    public void addEventListener(Class<?> event, IWorldEventListener<?> listener) {
        this.eventListeners.add(event, listener);
    }

    @Override
    public void addObjectListener(Class<?> objectClass, IWorldObjectEventListener<?, ?> listener) {
        this.objectsListeners.add(objectClass, listener);
    }

    @Override
    public void addObjectListener(Class<?> objectClass, Class<?> eventClass, IWorldObjectEventListener<?, ?> listener) {
        ListenersMap<Class> listeners = this.objectEventListeners.get(eventClass);
        listeners.add(objectClass, listener);
    }

    @Override
    public void addObjectListener(WorldObjectId objectId, IWorldObjectEventListener<?, ?> listener) {
        this.specificObjectListeners.add((Object)objectId, listener);
    }

    @Override
    public void addObjectListener(WorldObjectId objectId, Class<?> eventClass, IWorldObjectEventListener<?, ?> listener) {
        ListenersMap<Class> listeners = this.specificObjectEventListeners.get(objectId);
        listeners.add(eventClass, listener);
    }

    @Override
    public boolean isListening(Class<?> eventClass, IWorldEventListener<?> listener) {
        return this.eventListeners.isListening(eventClass, listener);
    }

    @Override
    public boolean isListening(Class<?> objectClass, IWorldObjectEventListener<?, ?> listener) {
        return this.objectsListeners.isListening(listener);
    }

    @Override
    public boolean isListening(Class<?> objectClass, Class<?> eventClass, IWorldObjectEventListener<?, ?> listener) {
        if (this.objectEventListeners.containsKey(objectClass)) {
            return this.objectEventListeners.get(eventClass).isListening(objectClass, listener);
        }
        return false;
    }

    @Override
    public boolean isListening(WorldObjectId objectId, IWorldObjectEventListener<?, ?> listener) {
        return this.specificObjectListeners.isListening((Object)objectId, listener);
    }

    @Override
    public boolean isListening(WorldObjectId objectId, Class<?> eventClass, IWorldObjectEventListener<?, ?> listener) {
        if (this.specificObjectEventListeners.containsKey(objectId)) {
            return this.specificObjectEventListeners.get(objectId).isListening(eventClass, listener);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isListening(IWorldEventListener<?> listener) {
        if (this.eventListeners.isListening(listener) || this.specificObjectListeners.isListening(listener)) {
            return true;
        }
        Map<Serializable, ListenersMap<Class>> map = this.objectEventListeners;
        synchronized (map) {
            for (ListenersMap<Class> listeners : this.objectEventListeners.values()) {
                if (!listeners.isListening(listener)) continue;
                return true;
            }
        }
        map = this.specificObjectEventListeners;
        synchronized (map) {
            for (ListenersMap<Class> listeners : this.specificObjectEventListeners.values()) {
                if (!listeners.isListening(listener)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void removeEventListener(Class<?> eventClass, IWorldEventListener<?> listener) {
        this.eventListeners.remove(eventClass, listener);
    }

    @Override
    public void removeObjectListener(Class<?> objectClass, IWorldObjectEventListener<?, ?> listener) {
        this.objectsListeners.remove(objectClass, listener);
    }

    @Override
    public void removeObjectListener(Class<?> objectClass, Class<?> eventClass, IWorldObjectEventListener<?, ?> listener) {
        if (this.objectEventListeners.containsKey(eventClass)) {
            this.objectEventListeners.get(eventClass).remove(objectClass, listener);
        }
    }

    @Override
    public void removeObjectListener(WorldObjectId objectId, IWorldObjectEventListener<?, ?> listener) {
        this.specificObjectListeners.remove((Object)objectId, listener);
    }

    @Override
    public void removeObjectListener(WorldObjectId objectId, Class<?> eventClass, IWorldObjectEventListener<?, ?> listener) {
        if (this.specificObjectEventListeners.containsKey(objectId)) {
            this.specificObjectEventListeners.get(objectId).remove(eventClass, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(IWorldEventListener<?> listener) {
        this.eventListeners.remove(listener);
        Map<Class, ListenersMap<Class>> map = this.objectEventListeners;
        synchronized (map) {
            for (ListenersMap<Class> listeners : this.objectEventListeners.values()) {
                listeners.remove(listener);
            }
        }
        this.specificObjectListeners.remove(listener);
        this.specificObjectEventListeners.remove(listener);
    }

    @Override
    public Map<Class, Map<WorldObjectId, IWorldObject>> getAll() {
        return this.syncWorldObjects;
    }

    @Override
    public <T extends IWorldObject> Map<WorldObjectId, T> getAll(Class<T> type) {
        return this.syncWorldObjects.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IWorldObject> T getSingle(Class<T> cls) {
        Collection<T> col = this.getAll(cls).values();
        if (col.size() > 1) {
            throw new IllegalArgumentException("There must be at most one object of given class (" + cls.getName() + ") to use this method. But there were more instances (" + col.size() + ").");
        }
        if (col.size() < 1) {
            return null;
        }
        Collection<T> collection = col;
        synchronized (collection) {
            return (T)((IWorldObject)col.iterator().next());
        }
    }

    @Override
    public IWorldObject get(WorldObjectId objectId) {
        return this.knownObjects.get(objectId);
    }

    @Override
    public Map<WorldObjectId, IWorldObject> get() {
        return this.knownObjects;
    }

    protected synchronized void addWorldObject(IWorldObject worldObject) {
        this.knownObjects.put(worldObject.getId(), worldObject);
        for (Class cls : ClassUtils.getSubclasses(worldObject.getClass())) {
            this.syncWorldObjects.get(cls).put(worldObject.getId(), worldObject);
        }
    }

    protected synchronized void removeWorldObject(IWorldObject worldObject) {
        this.knownObjects.remove(worldObject.getId());
        for (Class cls : ClassUtils.getSubclasses(worldObject.getClass())) {
            this.syncWorldObjects.get(cls).remove(worldObject.getId());
        }
    }

    protected synchronized void raiseEvent(IWorldEvent event) {
        if (this.raiseEventProcessing) {
            this.raiseEventsList.add(event);
            return;
        }
        this.raiseEventProcessing = true;
        this.innerRaiseEvent(event);
        while (this.raiseEventsList.size() != 0) {
            this.innerRaiseEvent(this.raiseEventsList.poll());
        }
        this.raiseEventProcessing = false;
    }

    private void notifyLevelAListeners(IWorldEvent event) {
        Collection eventClasses = ClassUtils.getSubclasses(event.getClass());
        this.notifier.setEvent(event);
        for (Class eventClass : eventClasses) {
            this.eventListeners.notify((Object)eventClass, (Listeners.ListenerNotifier)this.notifier);
        }
    }

    private void notifyLevelBListeners(IWorldObjectEvent event) {
        Object object = event.getObject();
        Collection objectClasses = ClassUtils.getSubclasses(object.getClass());
        this.notifier.setEvent(event);
        for (Class objectClass : objectClasses) {
            this.objectsListeners.notify((Object)objectClass, (Listeners.ListenerNotifier)this.notifier);
        }
    }

    private void notifyLevelCListeners(IWorldObjectEvent event) {
        Collection eventClasses = ClassUtils.getSubclasses(event.getClass());
        Collection objectClasses = ClassUtils.getSubclasses(event.getObject().getClass());
        this.notifier.setEvent(event);
        for (Class eventClass : eventClasses) {
            ListenersMap<Class> listeners = this.objectEventListeners.get(eventClass);
            if (listeners == null || !listeners.hasListeners()) continue;
            for (Class objectClass : objectClasses) {
                listeners.notify((Object)objectClass, (Listeners.ListenerNotifier)this.notifier);
            }
        }
    }

    private void notifyLevelDListeners(IWorldObjectEvent event) {
        this.notifier.setEvent(event);
        this.specificObjectListeners.notify((Object)event.getId(), (Listeners.ListenerNotifier)this.notifier);
    }

    private void notifyLevelEListeners(IWorldObjectEvent event) {
        this.notifier.setEvent(event);
        WorldObjectId objectId = event.getId();
        ListenersMap<Class> listeners = this.specificObjectEventListeners.get(objectId);
        if (listeners.hasListeners()) {
            Collection eventClasses = ClassUtils.getSubclasses(event.getClass());
            this.notifier.setEvent(event);
            for (Class eventClass : eventClasses) {
                listeners.notify((Object)eventClass, (Listeners.ListenerNotifier)this.notifier);
            }
        }
    }

    private void innerRaiseEvent(IWorldEvent event) {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("notifying " + event);
        }
        this.notifyLevelAListeners(event);
        if (event instanceof IWorldObjectEvent) {
            IWorldObjectEvent objectEvent = (IWorldObjectEvent)event;
            this.notifyLevelBListeners(objectEvent);
            this.notifyLevelCListeners(objectEvent);
            this.notifyLevelDListeners(objectEvent);
            this.notifyLevelEListeners(objectEvent);
        }
    }

    public String toString() {
        if (this == null) {
            return "AbstractWorldView-instantiating";
        }
        return this.getClass().getSimpleName();
    }

    private static class ListenerNotifier<T>
    implements Listeners.ListenerNotifier<IListener> {
        private T event = null;

        private ListenerNotifier() {
        }

        public T getEvent() {
            return this.event;
        }

        public void setEvent(T event) {
            this.event = event;
        }

        public void notify(IListener listener) {
            listener.notify(this.event);
        }
    }
}

